/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.jaxrs2.integration.resources.BaseOpenApiResource;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.integration.GenericOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.common.openapi.DefaultApplicationFactory;
import org.apache.cxf.jaxrs.common.openapi.SwaggerProperties;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizedResource;
import org.apache.cxf.jaxrs.openapi.OpenApiCustomizer;
import org.apache.cxf.jaxrs.openapi.OpenApiDefaultConfigurationScanner;
import org.apache.cxf.jaxrs.openapi.SwaggerUi;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiConfig;
import org.apache.cxf.jaxrs.swagger.ui.SwaggerUiSupport;

@Provider(value=Provider.Type.Feature, scope=Provider.Scope.Server)
public class OpenApiFeature
extends AbstractFeature
implements SwaggerUiSupport,
SwaggerProperties {
    private String version;
    private String title;
    private String description;
    private String contactName;
    private String contactEmail;
    private String contactUrl;
    private String license;
    private String licenseUrl;
    private String termsOfServiceUrl;
    private boolean readAllResources = true;
    private boolean scan = true;
    private boolean prettyPrint = true;
    private boolean runAsFilter;
    private Collection<String> ignoredRoutes;
    private Set<String> resourcePackages;
    private Set<String> resourceClasses;
    private String filterClass;
    private Boolean supportSwaggerUi;
    private String swaggerUiVersion;
    private String swaggerUiMavenGroupAndArtifact;
    private Map<String, String> swaggerUiMediaTypes;
    private Map<String, SecurityScheme> securityDefinitions;
    private OpenApiCustomizer customizer;
    private String configLocation;
    private String propertiesLocation = "/swagger.properties";
    private boolean scanKnownConfigLocations = true;
    private SwaggerUiConfig swaggerUiConfig;

    public void initialize(Server server, Bus bus) {
        GenericOpenApiContextBuilder openApiConfiguration;
        JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
        ServerProviderFactory factory = (ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName());
        HashSet<String> packages = new HashSet<String>();
        if (this.resourcePackages != null) {
            packages.addAll(this.resourcePackages);
        }
        Properties swaggerProps = null;
        Application application = DefaultApplicationFactory.createApplicationOrDefault((Server)server, (ServerProviderFactory)factory, (JAXRSServiceFactoryBean)sfb, (Bus)bus, this.resourcePackages, (boolean)this.isScan());
        String defaultConfigLocation = this.getConfigLocation();
        if (this.scanKnownConfigLocations && StringUtils.isEmpty((String)defaultConfigLocation)) {
            defaultConfigLocation = OpenApiDefaultConfigurationScanner.locateDefaultConfiguration().orElse(null);
        }
        if (StringUtils.isEmpty((String)defaultConfigLocation)) {
            swaggerProps = this.getSwaggerProperties(this.propertiesLocation, bus);
            if (this.isScan()) {
                packages.addAll(this.scanResourcePackages(sfb));
            }
            OpenAPI oas = new OpenAPI().info(this.getInfo(swaggerProps));
            OpenApiFeature.registerComponents(this.securityDefinitions).ifPresent(arg_0 -> ((OpenAPI)oas).setComponents(arg_0));
            SwaggerConfiguration config = new SwaggerConfiguration().openAPI(oas).prettyPrint(this.getOrFallback(this.isPrettyPrint(), swaggerProps, "pretty.print")).readAllResources(Boolean.valueOf(this.isReadAllResources())).ignoredRoutes(this.getIgnoredRoutes()).filterClass(this.getOrFallback(this.getFilterClass(), swaggerProps, "filter.class")).resourceClasses(this.getResourceClasses()).resourcePackages(this.getOrFallback(packages, swaggerProps, "resource.package"));
            openApiConfiguration = new JaxrsOpenApiContextBuilder().application(application).openApiConfiguration((OpenAPIConfiguration)config);
        } else {
            openApiConfiguration = new JaxrsOpenApiContextBuilder().application(application).configLocation(defaultConfigLocation);
        }
        try {
            OpenApiContext context = openApiConfiguration.buildContext(true);
            Properties userProperties = this.getUserProperties(context.getOpenApiConfiguration().getUserDefinedOptions());
            this.registerOpenApiResources(sfb, packages, context.getOpenApiConfiguration());
            this.registerSwaggerUiResources(sfb, OpenApiFeature.combine(swaggerProps, userProperties), factory, bus);
            this.registerSwaggerContainerRequestFilter(factory, application);
            if (this.customizer != null) {
                this.customizer.setApplicationInfo(factory.getApplicationProvider());
            }
            bus.setProperty("openapi.service.description.available", (Object)"true");
        }
        catch (OpenApiConfigurationException ex) {
            throw new RuntimeException("Unable to initialize OpenAPI context", ex);
        }
    }

    private void registerSwaggerContainerRequestFilter(ServerProviderFactory factory, Application application) {
        if (this.isRunAsFilter()) {
            ArrayList<SwaggerContainerRequestFilter> providers = new ArrayList<SwaggerContainerRequestFilter>();
            providers.add(new SwaggerContainerRequestFilter(application));
            factory.setUserProviders(providers);
        }
    }

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public Set<String> getResourcePackages() {
        return this.resourcePackages;
    }

    public void setResourcePackages(Set<String> resourcePackages) {
        this.resourcePackages = resourcePackages == null ? null : new HashSet<String>(resourcePackages);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public void setContactEmail(String contactEmail) {
        this.contactEmail = contactEmail;
    }

    public String getContactUrl() {
        return this.contactUrl;
    }

    public void setContactUrl(String contactUrl) {
        this.contactUrl = contactUrl;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    public boolean isReadAllResources() {
        return this.readAllResources;
    }

    public void setReadAllResources(boolean readAllResources) {
        this.readAllResources = readAllResources;
    }

    public Set<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(Set<String> resourceClasses) {
        this.resourceClasses = resourceClasses == null ? null : new HashSet<String>(resourceClasses);
    }

    public Collection<String> getIgnoredRoutes() {
        return this.ignoredRoutes;
    }

    public void setIgnoredRoutes(Collection<String> ignoredRoutes) {
        this.ignoredRoutes = ignoredRoutes == null ? null : new HashSet<String>(ignoredRoutes);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isRunAsFilter() {
        return this.runAsFilter;
    }

    public Boolean isSupportSwaggerUi() {
        return this.supportSwaggerUi;
    }

    public void setSupportSwaggerUi(Boolean supportSwaggerUi) {
        this.supportSwaggerUi = supportSwaggerUi;
    }

    public String getSwaggerUiVersion() {
        return this.swaggerUiVersion;
    }

    public void setSwaggerUiVersion(String swaggerUiVersion) {
        this.swaggerUiVersion = swaggerUiVersion;
    }

    public String getSwaggerUiMavenGroupAndArtifact() {
        return this.swaggerUiMavenGroupAndArtifact;
    }

    public void setSwaggerUiMavenGroupAndArtifact(String swaggerUiMavenGroupAndArtifact) {
        this.swaggerUiMavenGroupAndArtifact = swaggerUiMavenGroupAndArtifact;
    }

    public Map<String, String> getSwaggerUiMediaTypes() {
        return this.swaggerUiMediaTypes;
    }

    public void setSwaggerUiMediaTypes(Map<String, String> swaggerUiMediaTypes) {
        this.swaggerUiMediaTypes = swaggerUiMediaTypes;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public String getPropertiesLocation() {
        return this.propertiesLocation;
    }

    public void setPropertiesLocation(String propertiesLocation) {
        this.propertiesLocation = propertiesLocation;
    }

    public void setRunAsFilter(boolean runAsFilter) {
        this.runAsFilter = runAsFilter;
    }

    public Map<String, SecurityScheme> getSecurityDefinitions() {
        return this.securityDefinitions;
    }

    public void setSecurityDefinitions(Map<String, SecurityScheme> securityDefinitions) {
        this.securityDefinitions = securityDefinitions;
    }

    public OpenApiCustomizer getCustomizer() {
        return this.customizer;
    }

    public void setCustomizer(OpenApiCustomizer customizer) {
        this.customizer = customizer;
    }

    public void setScanKnownConfigLocations(boolean scanKnownConfigLocations) {
        this.scanKnownConfigLocations = scanKnownConfigLocations;
    }

    public boolean isScanKnownConfigLocations() {
        return this.scanKnownConfigLocations;
    }

    public void setSwaggerUiConfig(SwaggerUiConfig swaggerUiConfig) {
        this.swaggerUiConfig = swaggerUiConfig;
    }

    public SwaggerUiConfig getSwaggerUiConfig() {
        return this.swaggerUiConfig;
    }

    public String findSwaggerUiRoot() {
        return SwaggerUi.findSwaggerUiRoot(this.swaggerUiMavenGroupAndArtifact, this.swaggerUiVersion);
    }

    protected Properties getUserProperties(Map<String, Object> userDefinedOptions) {
        Properties properties = new Properties();
        if (userDefinedOptions != null) {
            userDefinedOptions.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> properties.setProperty((String)entry.getKey(), entry.getValue().toString()));
        }
        return properties;
    }

    protected void registerOpenApiResources(JAXRSServiceFactoryBean sfb, Set<String> packages, OpenAPIConfiguration config) {
        if (this.customizer != null) {
            this.customizer.setClassResourceInfos(sfb.getClassResourceInfo());
        }
        sfb.setResourceClassesFromBeans(Arrays.asList(this.createOpenApiResource().openApiConfiguration(config).configLocation(this.configLocation).resourcePackages(packages)));
    }

    protected void registerSwaggerUiResources(JAXRSServiceFactoryBean sfb, Properties properties, ServerProviderFactory factory, Bus bus) {
        SwaggerUiSupport.Registration swaggerUiRegistration = this.getSwaggerUi(bus, properties, this.isRunAsFilter());
        if (!this.isRunAsFilter()) {
            sfb.setResourceClassesFromBeans(swaggerUiRegistration.getResources());
        }
        factory.setUserProviders(swaggerUiRegistration.getProviders());
    }

    private Info getInfo(Properties properties) {
        Info info = new Info().title(this.getOrFallback(this.getTitle(), properties, "title")).version(this.getOrFallback(this.getVersion(), properties, "version")).description(this.getOrFallback(this.getDescription(), properties, "description")).termsOfService(this.getOrFallback(this.getTermsOfServiceUrl(), properties, "terms.url")).contact(new Contact().name(this.getOrFallback(this.getContactName(), properties, "contact")).email(this.getContactEmail()).url(this.getContactUrl())).license(new License().name(this.getOrFallback(this.getLicense(), properties, "license")).url(this.getOrFallback(this.getLicenseUrl(), properties, "license.url")));
        if (info.getLicense().getName() == null) {
            info.getLicense().setName("Apache 2.0 License");
        }
        if (info.getLicense().getUrl() == null && "Apache 2.0 License".equals(info.getLicense().getName())) {
            info.getLicense().setUrl("http://www.apache.org/licenses/LICENSE-2.0.html");
        }
        return info;
    }

    private String getOrFallback(String value, Properties properties, String property) {
        if (value == null && properties != null) {
            return properties.getProperty(property);
        }
        return value;
    }

    private Boolean getOrFallback(Boolean value, Properties properties, String property) {
        Boolean fallback = value;
        if (value == null && properties != null) {
            fallback = PropertyUtils.isTrue((Object)properties.get("pretty.print"));
        }
        if (fallback == null) {
            return false;
        }
        return fallback;
    }

    private Set<String> getOrFallback(Set<String> collection, Properties properties, String property) {
        String value;
        if (collection.isEmpty() && properties != null && !StringUtils.isEmpty((String)(value = properties.getProperty(property)))) {
            collection.add(value);
        }
        return collection;
    }

    private Collection<String> scanResourcePackages(JAXRSServiceFactoryBean sfb) {
        return sfb.getClassResourceInfo().stream().map(cri -> cri.getServiceClass().getPackage().getName()).collect(Collectors.toSet());
    }

    private static Properties combine(Properties primary, Properties secondary) {
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        Properties combined = new Properties();
        OpenApiFeature.setOrReplace(secondary, combined);
        OpenApiFeature.setOrReplace(primary, combined);
        return combined;
    }

    private static void setOrReplace(Properties source, Properties destination) {
        Enumeration<?> enumeration = source.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            destination.setProperty(name, source.getProperty(name));
        }
    }

    private static Optional<Components> registerComponents(Map<String, SecurityScheme> securityDefinitions) {
        Components components = new Components();
        boolean hasComponents = false;
        if (securityDefinitions != null && !securityDefinitions.isEmpty()) {
            securityDefinitions.forEach((key, value) -> components.addSecuritySchemes(key, value));
            hasComponents |= true;
        }
        return hasComponents ? Optional.of(components) : Optional.empty();
    }

    private OpenApiResource createOpenApiResource() {
        return this.customizer == null ? new OpenApiResource() : new OpenApiCustomizedResource(this.customizer);
    }

    @PreMatching
    protected static class SwaggerContainerRequestFilter
    extends BaseOpenApiResource
    implements ContainerRequestFilter {
        protected static final String APIDOCS_LISTING_PATH_JSON = "openapi.json";
        protected static final String APIDOCS_LISTING_PATH_YAML = "openapi.yaml";
        @Context
        protected MessageContext mc;
        private Application app;

        public SwaggerContainerRequestFilter(Application app) {
            this.app = app;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            Response response = null;
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                try {
                    response = super.getOpenApi(this.mc.getHttpHeaders(), this.mc.getServletConfig(), this.app, ui, "json");
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                try {
                    response = super.getOpenApi(this.mc.getHttpHeaders(), this.mc.getServletConfig(), this.app, ui, "yaml");
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
            if (response != null) {
                requestContext.abortWith(response);
            }
        }
    }
}

