/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import com.wordnik.swagger.jaxrs.config.BeanConfig;
import com.wordnik.swagger.jaxrs.listing.ApiDeclarationProvider;
import com.wordnik.swagger.jaxrs.listing.ApiListingResourceJSON;
import com.wordnik.swagger.jaxrs.listing.ResourceListingProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;

public class SwaggerFeature
extends AbstractSwaggerFeature {
    @Override
    protected void addSwaggerResource(Server server) {
        ApiListingResourceJSON apiListingResource = new ApiListingResourceJSON();
        if (!this.runAsFilter) {
            ArrayList<ApiListingResourceJSON> serviceBeans = new ArrayList<ApiListingResourceJSON>();
            serviceBeans.add(apiListingResource);
            ((JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName())).setResourceClassesFromBeans(serviceBeans);
        }
        ArrayList<SwaggerContainerRequestFilter> providers = new ArrayList<SwaggerContainerRequestFilter>();
        if (this.runAsFilter) {
            providers.add(new SwaggerContainerRequestFilter(apiListingResource));
        }
        providers.add((SwaggerContainerRequestFilter)new ResourceListingProvider());
        providers.add((SwaggerContainerRequestFilter)new ApiDeclarationProvider());
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setTermsOfServiceUrl(this.getTermsOfServiceUrl());
        beanConfig.setScan(this.isScan());
        beanConfig.setFilterClass(this.getFilterClass());
    }

    @Override
    protected void setBasePathByAddress(String address) {
        this.setBasePath(address);
    }

    @PreMatching
    private static class SwaggerContainerRequestFilter
    implements ContainerRequestFilter {
        private static final String APIDOCS_LISTING_PATH = "api-docs";
        private static final Pattern APIDOCS_RESOURCE_PATH = Pattern.compile("api-docs(/.+)");
        private ApiListingResourceJSON apiListingResource;
        @Context
        private MessageContext mc;

        public SwaggerContainerRequestFilter(ApiListingResourceJSON apiListingResource) {
            this.apiListingResource = apiListingResource;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH)) {
                Response r = this.apiListingResource.resourceListing(null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            } else {
                Matcher matcher = APIDOCS_RESOURCE_PATH.matcher(ui.getPath());
                if (matcher.find()) {
                    Response r = this.apiListingResource.apiDeclaration(matcher.group(1), null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                    requestContext.abortWith(r);
                }
            }
        }
    }
}

