/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient.hc5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;

abstract class MutableHttpEntity
implements HttpEntity {
    static final int OUTPUT_BUFFER_SIZE = 4096;
    private InputStream content;
    private String contentType;
    private String contentEncoding;
    private boolean chunked;
    private long length;

    MutableHttpEntity(String contentType, String contentEncoding, boolean chunked) {
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.chunked = chunked;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.content;
    }

    public boolean isStreaming() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public void setContentLength(long l) {
        this.length = l;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void close() throws IOException {
    }

    public Supplier<List<? extends Header>> getTrailers() {
        return null;
    }

    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public static void writeTo(HttpEntity entity, OutputStream outStream) throws IOException {
        try (InputStream inStream = entity.getContent();){
            if (inStream != null) {
                int count;
                byte[] tmp = new byte[4096];
                while ((count = inStream.read(tmp)) != -1) {
                    outStream.write(tmp, 0, count);
                }
            }
        }
    }

    public void writeTo(OutputStream outStream) throws IOException {
        MutableHttpEntity.writeTo(this, outStream);
    }
}

