/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.customer.bare;

import jakarta.annotation.Resource;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.customer.Customer;
import org.apache.cxf.customer.CustomerNotFoundDetails;
import org.apache.cxf.customer.CustomerNotFoundFault;
import org.apache.cxf.customer.Customers;
import org.apache.cxf.customer.bare.GetCustomer;
import org.apache.cxf.customer.bare.GetCustomers;

@WebService(targetNamespace="http://cxf.apache.org/jra")
public class CustomerService {
    long currentId = 1L;
    Map<Long, Customer> customers = new HashMap<Long, Customer>();
    @Resource
    private WebServiceContext context;

    public CustomerService() {
        Customer customer = this.createCustomer();
        this.customers.put(customer.getId(), customer);
    }

    @WebMethod
    @WebResult(name="customers")
    public Customers getCustomers(@WebParam(name="GetCustomers") GetCustomers req) {
        Customers cbean = new Customers();
        cbean.setCustomer(this.customers.values());
        if (this.context == null || this.context.getMessageContext() == null) {
            throw new WebServiceException("WebServiceContext is null!");
        }
        return cbean;
    }

    @WebMethod
    @WebResult(name="customer")
    public Customer getCustomer(@WebParam(name="getCustomer") GetCustomer getCustomer) throws CustomerNotFoundFault {
        Customer c = this.customers.get(getCustomer.getId());
        if (c == null) {
            CustomerNotFoundDetails details = new CustomerNotFoundDetails();
            details.setId(getCustomer.getId());
            throw new CustomerNotFoundFault(details);
        }
        return c;
    }

    @WebMethod
    public String getSomeDetails(@WebParam(name="getSomeDetails") GetCustomer getCustomer) throws CustomerNotFoundFault {
        return "some details";
    }

    @WebMethod
    public void updateCustomer(@WebParam(name="customer") Customer c) {
        this.customers.put(c.getId(), c);
    }

    @WebMethod
    public void addCustomer(@WebParam(name="customer") Customer c) {
        long id = ++this.currentId;
        c.setId(id);
        this.customers.put(id, c);
    }

    @WebMethod
    public void deleteCustomer(long id) {
        this.customers.remove(id);
    }

    final Customer createCustomer() {
        Customer c = new Customer();
        c.setName("Dan Diephouse");
        c.setId(123L);
        return c;
    }
}

