/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.Arrays;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import org.apache.cxf.tools.common.model.A;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.junit.Assert;
import org.junit.Test;

public class JAnnotationTest {
    @Test
    public void testList() throws Exception {
        JAnnotation annotation = new JAnnotation(XmlSeeAlso.class);
        annotation.addElement(new JAnnotationElement(null, Arrays.asList(XmlSeeAlso.class)));
        Assert.assertEquals((Object)"@XmlSeeAlso({XmlSeeAlso.class})", (Object)annotation.toString());
        Assert.assertEquals((Object)"javax.xml.bind.annotation.XmlSeeAlso", annotation.getImports().iterator().next());
    }

    @Test
    public void testSimpleForm() {
        JAnnotation annotation = new JAnnotation(WebService.class);
        Assert.assertEquals((Object)"@WebService", (Object)annotation.toString());
    }

    @Test
    public void testStringForm() {
        JAnnotation annotation = new JAnnotation(WebService.class);
        annotation.addElement(new JAnnotationElement("name", (Object)"AddNumbersPortType"));
        annotation.addElement(new JAnnotationElement("targetNamespace", (Object)"http://example.com/"));
        Assert.assertEquals((Object)"@WebService(name = \"AddNumbersPortType\", targetNamespace = \"http://example.com/\")", (Object)annotation.toString());
    }

    @Test
    public void testEnum() {
        JAnnotation annotation = new JAnnotation(SOAPBinding.class);
        annotation.addElement(new JAnnotationElement("parameterStyle", (Object)SOAPBinding.ParameterStyle.BARE));
        Assert.assertEquals((Object)"@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)", (Object)annotation.toString());
    }

    @Test
    public void testCombination() {
        JAnnotation annotation = new JAnnotation(Action.class);
        annotation.addElement(new JAnnotationElement("input", (Object)"3in"));
        annotation.addElement(new JAnnotationElement("output", (Object)"3out"));
        JAnnotation faultAction = new JAnnotation(FaultAction.class);
        faultAction.addElement(new JAnnotationElement("className", A.class));
        faultAction.addElement(new JAnnotationElement("value", (Object)"3fault"));
        annotation.addElement(new JAnnotationElement("fault", Arrays.asList(faultAction)));
        String expected = "@Action(input = \"3in\", output = \"3out\", fault = {@FaultAction(className = A.class, value = \"3fault\")})";
        Assert.assertEquals((Object)expected, (Object)annotation.toString());
        Assert.assertTrue((boolean)annotation.getImports().contains("javax.xml.ws.FaultAction"));
        Assert.assertTrue((boolean)annotation.getImports().contains("javax.xml.ws.Action"));
        Assert.assertTrue((boolean)annotation.getImports().contains("org.apache.cxf.tools.common.model.A"));
    }

    @Test
    public void testPrimitive() {
        JAnnotation annotation = new JAnnotation(WebParam.class);
        annotation.addElement(new JAnnotationElement("header", (Object)true, true));
        annotation.addElement(new JAnnotationElement("mode", (Object)WebParam.Mode.INOUT));
        Assert.assertEquals((Object)"@WebParam(header = true, mode = WebParam.Mode.INOUT)", (Object)annotation.toString());
    }

    @Test
    public void testAddSame() {
        JAnnotation annotation = new JAnnotation(WebParam.class);
        annotation.addElement(new JAnnotationElement("header", (Object)true, true));
        annotation.addElement(new JAnnotationElement("header", (Object)false, true));
        annotation.addElement(new JAnnotationElement("mode", (Object)WebParam.Mode.INOUT));
        annotation.addElement(new JAnnotationElement("mode", (Object)WebParam.Mode.OUT));
        Assert.assertEquals((Object)"@WebParam(header = false, mode = WebParam.Mode.OUT)", (Object)annotation.toString());
    }
}

