/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.util.HashMap;
import org.apache.cxf.tools.common.ToolContext;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorEnvironmentTest {
    @Test
    public void testGet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        String value = (String)env.get("k1");
        Assert.assertEquals((Object)"v1", (Object)value);
    }

    @Test
    public void testPut() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        env.put("k2", (Object)"v2");
        String value = (String)env.get("k2");
        Assert.assertEquals((Object)"v2", (Object)value);
    }

    @Test
    public void testRemove() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        env.put("k2", (Object)"v2");
        String value = (String)env.get("k2");
        Assert.assertEquals((Object)"v2", (Object)value);
        env.remove("k1");
        Assert.assertNull((Object)env.get("k1"));
    }

    @Test
    public void testContainsKey() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        Assert.assertTrue((boolean)env.containsKey("k1"));
    }

    @Test
    public void testGetDefaultValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "v1");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        String k1 = (String)env.get("k1", (Object)"v2");
        Assert.assertEquals((Object)"v1", (Object)k1);
        String k2 = (String)env.get("k2", (Object)"v2");
        Assert.assertEquals((Object)"v2", (Object)k2);
    }

    @Test
    public void testOptionSet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "true");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        Assert.assertTrue((boolean)env.optionSet("k1"));
        Assert.assertFalse((boolean)env.optionSet("k2"));
    }

    @Test
    public void testGetBooleanValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k1", "true");
        ToolContext env = new ToolContext();
        env.setParameters(map);
        Boolean k1 = Boolean.valueOf((String)env.get("k1"));
        Assert.assertTrue((boolean)k1);
        Boolean k2 = Boolean.valueOf((String)env.get("k2", (Object)"true"));
        Assert.assertTrue((boolean)k2);
        Boolean k3 = Boolean.valueOf((String)env.get("k3", (Object)"yes"));
        Assert.assertFalse((boolean)k3);
    }
}

