/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec;

import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.junit.Assert;
import org.junit.Test;

public class ToolSpecTest {
    ToolSpec toolSpec;

    @Test
    public void testConstruct() {
        this.toolSpec = null;
        this.toolSpec = new ToolSpec();
        Assert.assertNotNull((Object)this.toolSpec);
    }

    @Test
    public void testConstructFromInputStream() {
        String tsSource = "parser/resources/testtool.xml";
        try {
            this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        }
        catch (ToolException e) {
            throw new RuntimeException(e);
        }
        Assert.assertNull((Object)this.toolSpec.getAnnotation());
    }

    @Test
    public void testGetParameterDefault() throws Exception {
        String tsSource = "parser/resources/testtool.xml";
        this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        Assert.assertNull((Object)this.toolSpec.getAnnotation());
        Assert.assertNull((Object)this.toolSpec.getParameterDefault("namespace"));
        Assert.assertNull((Object)this.toolSpec.getParameterDefault("wsdlurl"));
    }

    @Test
    public void testGetStreamRefName1() throws Exception {
        String tsSource = "parser/resources/testtool1.xml";
        this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        Assert.assertEquals((String)"test getStreamRefName failed", (Object)this.toolSpec.getStreamRefName("streamref"), (Object)"namespace");
    }

    @Test
    public void testGetStreamRefName2() throws Exception {
        String tsSource = "parser/resources/testtool2.xml";
        this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        Assert.assertEquals((String)"test getStreamRefName2 failed", (Object)this.toolSpec.getStreamRefName("streamref"), (Object)"wsdlurl");
    }

    @Test
    public void testIsValidInputStream() throws Exception {
        String tsSource = "parser/resources/testtool1.xml";
        this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        Assert.assertTrue((boolean)this.toolSpec.isValidInputStream("testID"));
        Assert.assertFalse((boolean)this.toolSpec.isValidInputStream("dummyID"));
        Assert.assertTrue((this.toolSpec.getInstreamIds().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetHandler() throws Exception {
        String tsSource = "parser/resources/testtool1.xml";
        this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        Assert.assertNotNull((Object)this.toolSpec.getHandler());
        Assert.assertNotNull((Object)this.toolSpec.getHandler(this.getClass().getClassLoader()));
    }

    @Test
    public void testGetOutstreamIds() throws Exception {
        String tsSource = "parser/resources/testtool2.xml";
        this.toolSpec = new ToolSpec(this.getClass().getResourceAsStream(tsSource), false);
        Assert.assertTrue((this.toolSpec.getOutstreamIds().size() == 1 ? 1 : 0) != 0);
    }
}

