/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.Tag;
import org.apache.cxf.tools.common.TestFileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.util.ToolsStaxUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class ProcessorTestBase {
    public static final List<String> DEFAULT_IGNORE_ATTR = Arrays.asList("attributeFormDefault", "elementFormDefault", "form", "version", "part@name");
    public static final List<String> DEFAULT_IGNORE_TAG = Arrays.asList("sequence");
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder(){

        protected void before() throws Throwable {
            super.before();
            ProcessorTestBase.this.output = ProcessorTestBase.this.tmpDir.getRoot();
            ProcessorTestBase.this.env.put("outputdir", (Object)ProcessorTestBase.this.output.getCanonicalPath());
        }
    };
    protected File output;
    protected ToolContext env = new ToolContext();
    protected Map<QName, Set<String>> qnameAtts = new HashMap<QName, Set<String>>();

    public ProcessorTestBase() {
        this.addQNameAttribute(new QName("http://www.w3.org/2001/XMLSchema", "element"), "type");
    }

    protected final void addQNameAttribute(QName element, String local) {
        Set<String> a = this.qnameAtts.get(element);
        if (a == null) {
            this.qnameAtts.put(element, new HashSet());
            a = this.qnameAtts.get(element);
        }
        a.add(local);
    }

    @After
    public void tearDown() {
        this.env = null;
    }

    protected boolean isMOXy() {
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{String.class});
            return c.getClass().getName().contains(".eclipse");
        }
        catch (JAXBException e) {
            return false;
        }
    }

    protected String getLocation(String wsdlFile) throws URISyntaxException {
        return this.getClass().getResource(wsdlFile).toURI().toString();
    }

    protected void assertFileEquals(String resource, File location) throws IOException {
        String str1 = TestFileUtils.getStringFromStream(this.getClass().getResourceAsStream(resource));
        String str2 = TestFileUtils.getStringFromFile(location);
        StringTokenizer st1 = new StringTokenizer(str1, " \t\n\r\f(),");
        StringTokenizer st2 = new StringTokenizer(str2, " \t\n\r\f(),");
        ArrayList<String> unmatched = new ArrayList<String>();
        while (st1.hasMoreTokens()) {
            String tok1 = st1.nextToken();
            String tok2 = null;
            if (unmatched.contains(tok1)) {
                unmatched.remove(tok1);
                continue;
            }
            while (st2.hasMoreTokens() && !tok1.equals(tok2 = st2.nextToken())) {
                unmatched.add(tok2);
            }
            Assert.assertEquals((String)("Compare failed " + resource + " != " + location.getAbsolutePath()), (Object)tok1, (Object)tok2);
        }
        Assert.assertFalse((boolean)st1.hasMoreTokens());
        Assert.assertFalse((boolean)st2.hasMoreTokens());
        Assert.assertTrue((String)("Files did not match: " + unmatched), (boolean)unmatched.isEmpty());
    }

    protected void assertTagEquals(Tag expected, Tag source) {
        this.assertTagEquals(expected, source, DEFAULT_IGNORE_ATTR, DEFAULT_IGNORE_TAG);
    }

    protected void assertAttributesEquals(QName element, Map<QName, String> q1, Map<QName, String> q2, Collection<String> ignoreAttr) {
        for (Map.Entry<QName, String> attr : q1.entrySet()) {
            if (ignoreAttr.contains(attr.getKey().getLocalPart()) || ignoreAttr.contains(element.getLocalPart() + "@" + attr.getKey().getLocalPart())) continue;
            String found = q2.get(attr.getKey());
            if (found == null) {
                throw new AssertionError((Object)("Attribute: " + attr.getKey() + " is missing in " + element));
            }
            if (found.equals(attr.getValue())) continue;
            throw new ComparisonFailure("Attribute not equal: ", attr.getKey() + ":" + attr.getValue(), attr.getKey() + ":" + found);
        }
    }

    protected void assertTagEquals(Tag expected, Tag source, List<String> ignoreAttr, List<String> ignoreTag) {
        if (!expected.getName().equals(source.getName())) {
            throw new ComparisonFailure("Tags not equal: ", expected.getName().toString(), source.getName().toString());
        }
        this.assertAttributesEquals(expected.getName(), expected.getAttributes(), source.getAttributes(), ignoreAttr);
        this.assertAttributesEquals(expected.getName(), source.getAttributes(), expected.getAttributes(), ignoreAttr);
        if (!StringUtils.isEmpty((String)expected.getText()) && !expected.getText().equals(source.getText())) {
            throw new ComparisonFailure("Text not equal: ", expected.getText(), source.getText());
        }
        if (!expected.getTags().isEmpty()) {
            for (Tag expectedTag : expected.getTags()) {
                if (ignoreTag.contains(expectedTag.getName().getLocalPart()) && expectedTag.getTags().isEmpty()) continue;
                Tag sourceTag = this.getFromSource(source, expectedTag);
                if (sourceTag == null) {
                    throw new AssertionError((Object)("\n" + expectedTag.toString() + " is missing in the source file:\n" + source.toString()));
                }
                this.assertTagEquals(expectedTag, sourceTag, ignoreAttr, ignoreTag);
            }
        }
    }

    private Tag getFromSource(Tag sourceTag, Tag expectedTag) {
        for (Tag tag : sourceTag.getTags()) {
            if (!tag.equals(expectedTag)) continue;
            return tag;
        }
        return null;
    }

    public void assertWsdlEquals(InputStream expected, File source, List<String> attr, List<String> tag) throws Exception {
        Tag expectedTag = ToolsStaxUtils.getTagTree(expected, attr, this.qnameAtts);
        Tag sourceTag = ToolsStaxUtils.getTagTree(source, attr, this.qnameAtts);
        this.assertTagEquals(expectedTag, sourceTag, attr, tag);
    }

    public void assertWsdlEquals(InputStream expected, File source) throws Exception {
        this.assertWsdlEquals(expected, source, DEFAULT_IGNORE_ATTR, DEFAULT_IGNORE_TAG);
    }

    public void assertWsdlEquals(InputStream expected, InputStream source, List<String> attr, List<String> tag) throws Exception {
        Tag expectedTag = ToolsStaxUtils.getTagTree(expected, attr, this.qnameAtts);
        Tag sourceTag = ToolsStaxUtils.getTagTree(source, attr, this.qnameAtts);
        this.assertTagEquals(expectedTag, sourceTag, attr, tag);
    }

    public void assertWsdlEquals(InputStream expected, InputStream source) throws Exception {
        this.assertWsdlEquals(expected, source, DEFAULT_IGNORE_ATTR, DEFAULT_IGNORE_TAG);
    }
}

