/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;
import org.apache.cxf.tools.validator.internal.Stax2DOM;
import org.apache.cxf.tools.validator.internal.ValidationResult;
import org.apache.cxf.tools.validator.internal.ValidatorUtil;
import org.apache.cxf.tools.validator.internal.model.FailureLocation;
import org.apache.cxf.tools.validator.internal.model.XBinding;
import org.apache.cxf.tools.validator.internal.model.XDef;
import org.apache.cxf.tools.validator.internal.model.XFault;
import org.apache.cxf.tools.validator.internal.model.XInput;
import org.apache.cxf.tools.validator.internal.model.XMessage;
import org.apache.cxf.tools.validator.internal.model.XNode;
import org.apache.cxf.tools.validator.internal.model.XOperation;
import org.apache.cxf.tools.validator.internal.model.XOutput;
import org.apache.cxf.tools.validator.internal.model.XPort;
import org.apache.cxf.tools.validator.internal.model.XPortType;
import org.apache.cxf.tools.validator.internal.model.XService;
import org.apache.cxf.wsdl11.WSDLDefinitionBuilder;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLRefValidator
extends AbstractDefinitionValidator {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLRefValidator.class);
    protected List<XNode> vNodes = new ArrayList<XNode>();
    private Set<QName> portTypeRefNames = new HashSet<QName>();
    private Set<QName> messageRefNames = new HashSet<QName>();
    private Map<QName, Service> services = new HashMap<QName, Service>();
    private ValidationResult vResults = new ValidationResult();
    private Definition definition;
    private List<Definition> importedDefinitions;
    private List<SchemaCollection> schemas = new ArrayList<SchemaCollection>();
    private SchemaCollection schemaCollection = new SchemaCollection();
    private boolean suppressWarnings;

    public WSDLRefValidator() {
    }

    public WSDLRefValidator(String wsdl) {
        this(wsdl, null);
    }

    public WSDLRefValidator(String wsdl, Document doc) {
        this(wsdl, doc, null);
    }

    public WSDLRefValidator(String wsdl, Document doc, Bus b) {
        WSDLDefinitionBuilder wsdlBuilder = new WSDLDefinitionBuilder();
        if (b != null) {
            wsdlBuilder.setBus(b);
        }
        try {
            this.definition = wsdlBuilder.build(wsdl);
            if (wsdlBuilder.getImportedDefinitions().size() > 0) {
                this.importedDefinitions = new ArrayList<Definition>();
                this.importedDefinitions.addAll(wsdlBuilder.getImportedDefinitions());
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof WSDLException) {
                throw new ToolException(e.getCause().getMessage());
            }
            throw new ToolException((Throwable)e);
        }
        try {
            this.schemas.add(ValidatorUtil.getSchema(this.definition));
            this.checkTargetNamespace(this.definition.getTargetNamespace());
            if (this.importedDefinitions != null) {
                for (Definition d : this.importedDefinitions) {
                    this.checkTargetNamespace(d.getTargetNamespace());
                    this.schemas.add(ValidatorUtil.getSchema(d));
                }
            }
        }
        catch (Exception ex) {
            throw new ToolException((Throwable)ex);
        }
    }

    private void checkTargetNamespace(String path) {
        try {
            if (new URL(path).getPath().indexOf(":") != -1) {
                throw new ToolException(": is not a valid char in the targetNamespace");
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setSuppressWarnings(boolean s) {
        this.suppressWarnings = s;
    }

    public ValidationResult getValidationResults() {
        return this.vResults;
    }

    private Document getWSDLDocument(String wsdl) throws URISyntaxException {
        return new Stax2DOM().getDocument(wsdl);
    }

    private Document getWSDLDocument() throws Exception {
        return this.getWSDLDocument(this.definition.getDocumentBaseURI());
    }

    private List<Document> getWSDLDocuments() {
        ArrayList<Document> docs = new ArrayList<Document>();
        try {
            docs.add(this.getWSDLDocument());
            if (null != this.importedDefinitions) {
                for (Definition d : this.importedDefinitions) {
                    docs.add(this.getWSDLDocument(d.getDocumentBaseURI()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return docs;
    }

    private boolean isExist(List<Document> docs, XNode vNode) {
        XPathUtils xpather = new XPathUtils(vNode.getNSMap());
        String expression = vNode.toString();
        for (Document doc : docs) {
            if (!xpather.isExist(expression, (Node)doc, XPathConstants.NODE)) continue;
            return true;
        }
        return false;
    }

    private FailureLocation getFailureLocation(List<Document> docs, XNode fNode) {
        if (fNode == null) {
            return null;
        }
        XPathUtils xpather = new XPathUtils(fNode.getNSMap());
        for (Document doc : docs) {
            Node node = (Node)xpather.getValue(fNode.toString(), (Node)doc, XPathConstants.NODE);
            if (null == node) continue;
            return new FailureLocation((Location)node.getUserData("location"), doc.getDocumentURI());
        }
        return null;
    }

    public boolean isValid() {
        try {
            this.loadServices();
            this.collectValidationPoints();
            List<Document> wsdlDocs = this.getWSDLDocuments();
            for (XNode vNode : this.vNodes) {
                if (this.isExist(wsdlDocs, vNode)) continue;
                FailureLocation loc = this.getFailureLocation(wsdlDocs, vNode.getFailurePoint());
                this.vResults.addError(new org.apache.cxf.common.i18n.Message("FAILED_AT_POINT", LOG, new Object[]{loc.getLocation().getLineNumber(), loc.getLocation().getColumnNumber(), loc.getDocumentURI(), vNode.getPlainText()}));
            }
        }
        catch (ToolException e) {
            this.vResults.addError(e.getMessage());
            return false;
        }
        return this.vResults.isSuccessful();
    }

    private void addServices(Definition wsdlDef) {
        for (QName sName : wsdlDef.getServices().keySet()) {
            this.services.put(sName, this.definition.getService(sName));
        }
    }

    private void loadServices() {
        this.addServices(this.definition);
        if (this.importedDefinitions != null) {
            for (Definition d : this.importedDefinitions) {
                this.addServices(d);
            }
        }
    }

    private Map<QName, XNode> getBindings(Service service) {
        HashMap<QName, XNode> bindings = new HashMap<QName, XNode>();
        if (service.getPorts().values().size() == 0) {
            throw new ToolException("Service " + service.getQName() + " does not contain any usable ports");
        }
        for (Port port : service.getPorts().values()) {
            Binding binding = port.getBinding();
            bindings.put(binding.getQName(), this.getXNode(service, port));
            if (!"http://schemas.xmlsoap.org/wsdl/".equals(binding.getQName().getNamespaceURI())) continue;
            throw new ToolException("Binding " + binding.getQName().getLocalPart() + " namespace set improperly.");
        }
        return bindings;
    }

    private Map<QName, Operation> getOperations(PortType portType) {
        HashMap<QName, Operation> operations = new HashMap<QName, Operation>();
        for (Operation op : portType.getOperations()) {
            operations.put(new QName(portType.getQName().getNamespaceURI(), op.getName()), op);
        }
        return operations;
    }

    private XNode getXNode(Service service, Port port) {
        XNode vService = this.getXNode(service);
        XPort pNode = new XPort();
        pNode.setName(port.getName());
        pNode.setParentNode(vService);
        return pNode;
    }

    private XNode getXNode(Service service) {
        XDef xdef = new XDef();
        xdef.setTargetNamespace(service.getQName().getNamespaceURI());
        XService sNode = new XService();
        sNode.setName(service.getQName().getLocalPart());
        sNode.setParentNode(xdef);
        return sNode;
    }

    private XNode getXNode(Binding binding) {
        XDef xdef = new XDef();
        xdef.setTargetNamespace(binding.getQName().getNamespaceURI());
        XBinding bNode = new XBinding();
        bNode.setName(binding.getQName().getLocalPart());
        bNode.setParentNode(xdef);
        return bNode;
    }

    private XNode getXNode(PortType portType) {
        XDef xdef = new XDef();
        xdef.setTargetNamespace(portType.getQName().getNamespaceURI());
        XPortType pNode = new XPortType();
        pNode.setName(portType.getQName().getLocalPart());
        pNode.setParentNode(xdef);
        return pNode;
    }

    private XNode getOperationXNode(XNode pNode, String opName) {
        XOperation node = new XOperation();
        node.setName(opName);
        node.setParentNode(pNode);
        return node;
    }

    private XNode getInputXNode(XNode opVNode, String name) {
        XInput oNode = new XInput();
        oNode.setName(name);
        oNode.setParentNode(opVNode);
        return oNode;
    }

    private XNode getOutputXNode(XNode opVNode, String name) {
        XOutput oNode = new XOutput();
        oNode.setName(name);
        oNode.setParentNode(opVNode);
        return oNode;
    }

    private XNode getFaultXNode(XNode opVNode, String name) {
        XFault oNode = new XFault();
        oNode.setName(name);
        oNode.setParentNode(opVNode);
        return oNode;
    }

    private XNode getXNode(Message msg) {
        XDef xdef = new XDef();
        xdef.setTargetNamespace(msg.getQName().getNamespaceURI());
        XMessage mNode = new XMessage();
        mNode.setName(msg.getQName().getLocalPart());
        mNode.setParentNode(xdef);
        return mNode;
    }

    private void addWarning(String warningMsg) {
        if (this.suppressWarnings) {
            return;
        }
        this.vResults.addWarning(warningMsg);
    }

    private void collectValidationPoints() {
        if (this.services.size() == 0) {
            LOG.log(Level.WARNING, "WSDL document " + this.definition.getDocumentBaseURI() + " does not define any services");
            this.portTypeRefNames.addAll(this.definition.getAllPortTypes().keySet());
        } else {
            this.collectValidationPointsForBindings();
        }
        this.collectValidationPointsForPortTypes();
        this.collectValidationPointsForMessages();
    }

    private void collectValidationPointsForBindings() {
        HashMap<QName, XNode> vBindingNodes = new HashMap<QName, XNode>();
        for (Service service : this.services.values()) {
            vBindingNodes.putAll(this.getBindings(service));
        }
        for (QName bName : vBindingNodes.keySet()) {
            Binding binding = this.definition.getBinding(bName);
            XNode vBindingNode = this.getXNode(binding);
            vBindingNode.setFailurePoint((XNode)vBindingNodes.get(bName));
            this.vNodes.add(vBindingNode);
            if (binding.getPortType() == null) continue;
            this.portTypeRefNames.add(binding.getPortType().getQName());
            XNode vPortTypeNode = this.getXNode(binding.getPortType());
            vPortTypeNode.setFailurePoint(vBindingNode);
            this.vNodes.add(vPortTypeNode);
            for (BindingOperation bop : binding.getBindingOperations()) {
                String outName;
                String inName;
                XNode vOpNode = this.getOperationXNode(vPortTypeNode, bop.getName());
                XNode vBopNode = this.getOperationXNode(vBindingNode, bop.getName());
                vOpNode.setFailurePoint(vBopNode);
                this.vNodes.add(vOpNode);
                if (bop.getBindingInput() != null && !StringUtils.isEmpty((String)(inName = bop.getBindingInput().getName()))) {
                    XNode vInputNode = this.getInputXNode(vOpNode, inName);
                    vInputNode.setFailurePoint(this.getInputXNode(vBopNode, inName));
                    this.vNodes.add(vInputNode);
                }
                if (bop.getBindingOutput() != null && !StringUtils.isEmpty((String)(outName = bop.getBindingOutput().getName()))) {
                    XNode vOutputNode = this.getOutputXNode(vOpNode, outName);
                    vOutputNode.setFailurePoint(this.getOutputXNode(vBopNode, outName));
                    this.vNodes.add(vOutputNode);
                }
                for (String faultName : bop.getBindingFaults().keySet()) {
                    XNode vFaultNode = this.getFaultXNode(vOpNode, faultName);
                    vFaultNode.setFailurePoint(this.getFaultXNode(vBopNode, faultName));
                    this.vNodes.add(vFaultNode);
                }
            }
        }
    }

    private Message getMessage(QName msgName) {
        Message message;
        block1: {
            Definition d;
            message = this.definition.getMessage(msgName);
            if (message != null) break block1;
            Iterator<Definition> i$ = this.importedDefinitions.iterator();
            while (i$.hasNext() && (message = (d = i$.next()).getMessage(msgName)) == null) {
            }
        }
        return message;
    }

    private void collectValidationPointsForMessages() {
        for (QName msgName : this.messageRefNames) {
            Message message = this.getMessage(msgName);
            for (Part part : message.getParts().values()) {
                boolean valid;
                QName elementName = part.getElementName();
                QName typeName = part.getTypeName();
                if (elementName == null && typeName == null) {
                    this.vResults.addError(new org.apache.cxf.common.i18n.Message("PART_NO_TYPES", LOG, new Object[0]));
                    continue;
                }
                if (elementName != null && typeName != null) {
                    this.vResults.addError(new org.apache.cxf.common.i18n.Message("PART_NOT_UNIQUE", LOG, new Object[0]));
                    continue;
                }
                if (elementName != null && typeName == null && !(valid = this.validatePartType(elementName.getNamespaceURI(), elementName.getLocalPart(), true))) {
                    this.vResults.addError(new org.apache.cxf.common.i18n.Message("TYPE_REF_NOT_FOUND", LOG, new Object[]{message.getQName(), part.getName(), elementName}));
                }
                if (typeName == null || elementName != null || (valid = this.validatePartType(typeName.getNamespaceURI(), typeName.getLocalPart(), false))) continue;
                this.vResults.addError(new org.apache.cxf.common.i18n.Message("TYPE_REF_NOT_FOUND", LOG, new Object[]{message.getQName(), part.getName(), typeName}));
            }
        }
    }

    private PortType getPortType(QName ptName) {
        PortType portType;
        block1: {
            Definition d;
            portType = this.definition.getPortType(ptName);
            if (portType != null) break block1;
            Iterator<Definition> i$ = this.importedDefinitions.iterator();
            while (i$.hasNext() && (portType = (d = i$.next()).getPortType(ptName)) == null) {
            }
        }
        return portType;
    }

    private void collectValidationPointsForPortTypes() {
        for (QName ptName : this.portTypeRefNames) {
            PortType portType = this.getPortType(ptName);
            if (portType == null) {
                this.vResults.addError(new org.apache.cxf.common.i18n.Message("NO_PORTTYPE", LOG, new Object[]{ptName}));
                continue;
            }
            XNode vPortTypeNode = this.getXNode(portType);
            for (Operation operation : this.getOperations(portType).values()) {
                XNode vOperationNode = this.getOperationXNode(vPortTypeNode, operation.getName());
                if (operation.getInput() == null) {
                    this.vResults.addError(new org.apache.cxf.common.i18n.Message("WRONG_MEP", LOG, new Object[]{operation.getName(), portType.getQName()}));
                    continue;
                }
                Message inMsg = operation.getInput().getMessage();
                if (inMsg == null) {
                    this.addWarning("Operation " + operation.getName() + " in PortType: " + portType.getQName() + " has no input message");
                } else {
                    XNode vInMsgNode = this.getXNode(inMsg);
                    vInMsgNode.setFailurePoint(this.getInputXNode(vOperationNode, operation.getInput().getName()));
                    this.vNodes.add(vInMsgNode);
                    this.messageRefNames.add(inMsg.getQName());
                }
                if (operation.getOutput() != null) {
                    Message outMsg = operation.getOutput().getMessage();
                    if (outMsg == null) {
                        this.addWarning("Operation " + operation.getName() + " in PortType: " + portType.getQName() + " has no output message");
                    } else {
                        XNode vOutMsgNode = this.getXNode(outMsg);
                        vOutMsgNode.setFailurePoint(this.getOutputXNode(vOperationNode, operation.getOutput().getName()));
                        this.vNodes.add(vOutMsgNode);
                        this.messageRefNames.add(outMsg.getQName());
                    }
                }
                for (Fault fault : operation.getFaults().values()) {
                    Message faultMsg = fault.getMessage();
                    XNode vFaultMsgNode = this.getXNode(faultMsg);
                    vFaultMsgNode.setFailurePoint(this.getFaultXNode(vOperationNode, fault.getName()));
                    this.vNodes.add(vFaultMsgNode);
                    this.messageRefNames.add(faultMsg.getQName());
                }
            }
        }
    }

    private boolean validatePartType(String namespace, String name, boolean isElement) {
        boolean partvalid = false;
        if (namespace.equals("http://www.w3.org/2001/XMLSchema")) {
            if (isElement) {
                XmlSchemaElement schemaEle = this.schemaCollection.getElementByQName(new QName("http://www.w3.org/2001/XMLSchema", name));
                partvalid = schemaEle != null;
            } else {
                if ("anyType".equals(name)) {
                    return true;
                }
                XmlSchemaType schemaType = this.schemaCollection.getTypeByQName(new QName("http://www.w3.org/2001/XMLSchema", name));
                partvalid = schemaType != null;
            }
        } else if (isElement) {
            for (SchemaCollection schema : this.schemas) {
                if (schema == null || schema.getElementByQName(new QName(namespace, name)) == null) continue;
                partvalid = true;
                break;
            }
        } else {
            for (SchemaCollection schema : this.schemas) {
                if (schema == null || schema.getTypeByQName(new QName(namespace, name)) == null) continue;
                partvalid = true;
                break;
            }
        }
        return partvalid;
    }

    public String getErrorMessage() {
        return this.vResults.toString();
    }

    public Definition getDefinition() {
        return this.definition;
    }
}

