/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.URIParserUtil;
import org.w3c.dom.Document;

public class Stax2DOM {
    static final String XML_NS = "http://www.w3.org/2000/xmlns/";

    public Document getDocument(String wsdl) throws ToolException {
        try {
            URI wsdlURI = new URI(URIParserUtil.getAbsoluteURI((String)wsdl));
            if (wsdlURI.toString().startsWith("http")) {
                return this.getDocument(wsdlURI.toURL());
            }
            return this.getDocument(wsdlURI.toURL());
        }
        catch (ToolException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    public Document getDocument(URL url) throws ToolException {
        try {
            StreamSource src = new StreamSource(url.openStream(), url.toExternalForm());
            return StaxUtils.read((XMLStreamReader)StaxUtils.createXMLStreamReader((Source)src), (boolean)true);
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    public Document getDocument(File wsdl) throws ToolException {
        try {
            StreamSource src = new StreamSource(wsdl);
            return StaxUtils.read((XMLStreamReader)StaxUtils.createXMLStreamReader((Source)src), (boolean)true);
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }
}

