/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jute.compiler.JFile;
import org.apache.jute.compiler.JRecord;

class CGenerator {
    private String mFullName;
    private String mName;
    private ArrayList mInclFiles;
    private ArrayList mRecList;
    private final File outputDirectory;

    CGenerator(String name, ArrayList ilist, ArrayList rlist, File outputDirectory) {
        this.mFullName = name;
        this.outputDirectory = outputDirectory;
        this.mName = new File(name).getName();
        this.mInclFiles = ilist;
        this.mRecList = rlist;
    }

    void genCode() throws IOException {
        this.outputDirectory.mkdirs();
        FileWriter c = new FileWriter(new File(this.outputDirectory, this.mName + ".c"));
        FileWriter h = new FileWriter(new File(this.outputDirectory, this.mName + ".h"));
        h.write("#ifndef __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        h.write("#define __" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        h.write("#include \"recordio.h\"\n");
        for (JFile f : this.mInclFiles) {
            h.write("#include \"" + f.getName() + ".h\"\n");
        }
        h.write("\n#ifdef __cplusplus\nextern \"C\" {\n#endif\n\n");
        c.write("#include <stdlib.h>\n");
        c.write("#include \"" + this.mName + ".h\"\n\n");
        for (JRecord jr : this.mRecList) {
            jr.genCCode(h, c);
        }
        h.write("\n#ifdef __cplusplus\n}\n#endif\n\n");
        h.write("#endif //" + this.mName.toUpperCase().replace('.', '_') + "__\n");
        h.close();
        c.close();
    }
}

