/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.jute.compiler.CGenerator;
import org.apache.jute.compiler.CppGenerator;
import org.apache.jute.compiler.JavaGenerator;

public class JFile {
    private String mName;
    private ArrayList mInclFiles;
    private ArrayList mRecords;

    public JFile(String name, ArrayList inclFiles, ArrayList recList) {
        this.mName = name;
        this.mInclFiles = inclFiles;
        this.mRecords = recList;
    }

    String getName() {
        int idx = this.mName.lastIndexOf(47);
        return idx > 0 ? this.mName.substring(idx) : this.mName;
    }

    public void genCode(String language, File outputDirectory) throws IOException {
        if ("c++".equals(language)) {
            CppGenerator gen = new CppGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else if ("java".equals(language)) {
            JavaGenerator gen = new JavaGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else if ("c".equals(language)) {
            CGenerator gen = new CGenerator(this.mName, this.mInclFiles, this.mRecords, outputDirectory);
            gen.genCode();
        } else {
            System.out.println("Cannnot recognize language:" + language);
            System.exit(1);
        }
    }
}

