/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import org.apache.jute.compiler.JCompType;
import org.apache.jute.compiler.JType;

public class JMap
extends JCompType {
    private static int level = 0;
    private JType mKey;
    private JType mValue;

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    private static String getId(String id) {
        return id + JMap.getLevel();
    }

    public JMap(JType t1, JType t2) {
        super("#error", " ::std::map<" + t1.getCppType() + "," + t2.getCppType() + ">", "java.util.TreeMap", "Map", "java.util.TreeMap");
        this.mKey = t1;
        this.mValue = t2;
    }

    public String getSignature() {
        return "{" + this.mKey.getSignature() + this.mValue.getSignature() + "}";
    }

    public String genJavaCompareTo(String fname) {
        return "";
    }

    public String genJavaReadWrapper(String fname, String tag, boolean decl) {
        StringBuffer ret = new StringBuffer("");
        if (decl) {
            ret.append("    java.util.TreeMap " + fname + ";\n");
        }
        ret.append("    {\n");
        JMap.incrLevel();
        ret.append("      org.apache.jute.Index " + JMap.getId("midx") + " = a_.startMap(\"" + tag + "\");\n");
        ret.append("      " + fname + "=new java.util.TreeMap();\n");
        ret.append("      for (; !" + JMap.getId("midx") + ".done(); " + JMap.getId("midx") + ".incr()) {\n");
        ret.append(this.mKey.genJavaReadWrapper(JMap.getId("k"), JMap.getId("k"), true));
        ret.append(this.mValue.genJavaReadWrapper(JMap.getId("v"), JMap.getId("v"), true));
        ret.append("        " + fname + ".put(" + JMap.getId("k") + "," + JMap.getId("v") + ");\n");
        ret.append("      }\n");
        ret.append("    a_.endMap(\"" + tag + "\");\n");
        JMap.decrLevel();
        ret.append("    }\n");
        return ret.toString();
    }

    public String genJavaReadMethod(String fname, String tag) {
        return this.genJavaReadWrapper(fname, tag, false);
    }

    public String genJavaWriteWrapper(String fname, String tag) {
        StringBuffer ret = new StringBuffer("    {\n");
        JMap.incrLevel();
        ret.append("      a_.startMap(" + fname + ",\"" + tag + "\");\n");
        ret.append("      java.util.Set " + JMap.getId("es") + " = " + fname + ".entrySet();\n");
        ret.append("      for(java.util.Iterator " + JMap.getId("midx") + " = " + JMap.getId("es") + ".iterator(); " + JMap.getId("midx") + ".hasNext(); ) {\n");
        ret.append("        java.util.Map.Entry " + JMap.getId("me") + " = (java.util.Map.Entry) " + JMap.getId("midx") + ".next();\n");
        ret.append("        " + this.mKey.getJavaWrapperType() + " " + JMap.getId("k") + " = (" + this.mKey.getJavaWrapperType() + ") " + JMap.getId("me") + ".getKey();\n");
        ret.append("        " + this.mValue.getJavaWrapperType() + " " + JMap.getId("v") + " = (" + this.mValue.getJavaWrapperType() + ") " + JMap.getId("me") + ".getValue();\n");
        ret.append(this.mKey.genJavaWriteWrapper(JMap.getId("k"), JMap.getId("k")));
        ret.append(this.mValue.genJavaWriteWrapper(JMap.getId("v"), JMap.getId("v")));
        ret.append("      }\n");
        ret.append("      a_.endMap(" + fname + ",\"" + tag + "\");\n");
        ret.append("    }\n");
        JMap.decrLevel();
        return ret.toString();
    }

    public String genJavaWriteMethod(String fname, String tag) {
        return this.genJavaWriteWrapper(fname, tag);
    }
}

