/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute.compiler;

import org.apache.jute.compiler.JCompType;
import org.apache.jute.compiler.JRecord;
import org.apache.jute.compiler.JType;

public class JVector
extends JCompType {
    private static int level = 0;
    private JType mElement;

    private static String getId(String id) {
        return id + JVector.getLevel();
    }

    private static String getLevel() {
        return Integer.toString(level);
    }

    private static void incrLevel() {
        ++level;
    }

    private static void decrLevel() {
        --level;
    }

    public JVector(JType t) {
        super("struct " + JVector.extractVectorName(t), " ::std::vector<" + t.getCppType() + ">", "java.util.List<" + t.getJavaType() + ">", "Vector", "java.util.ArrayList<" + t.getJavaType() + ">");
        this.mElement = t;
    }

    public String getSignature() {
        return "[" + this.mElement.getSignature() + "]";
    }

    public String genJavaCompareTo(String fname) {
        return "";
    }

    public String genJavaReadWrapper(String fname, String tag, boolean decl) {
        StringBuffer ret = new StringBuffer("");
        if (decl) {
            ret.append("      java.util.List " + fname + ";\n");
        }
        ret.append("    {\n");
        JVector.incrLevel();
        ret.append("      Index " + JVector.getId("vidx") + " = a_.startVector(\"" + tag + "\");\n");
        ret.append("      if (" + JVector.getId("vidx") + "!= null) {");
        ret.append("          " + fname + "=new java.util.ArrayList<" + this.mElement.getJavaType() + ">();\n");
        ret.append("          for (; !" + JVector.getId("vidx") + ".done(); " + JVector.getId("vidx") + ".incr()) {\n");
        ret.append(this.mElement.genJavaReadWrapper(JVector.getId("e"), JVector.getId("e"), true));
        ret.append("            " + fname + ".add(" + JVector.getId("e") + ");\n");
        ret.append("          }\n");
        ret.append("      }\n");
        ret.append("    a_.endVector(\"" + tag + "\");\n");
        JVector.decrLevel();
        ret.append("    }\n");
        return ret.toString();
    }

    public String genJavaReadMethod(String fname, String tag) {
        return this.genJavaReadWrapper(fname, tag, false);
    }

    public String genJavaWriteWrapper(String fname, String tag) {
        StringBuffer ret = new StringBuffer("    {\n");
        JVector.incrLevel();
        ret.append("      a_.startVector(" + fname + ",\"" + tag + "\");\n");
        ret.append("      if (" + fname + "!= null) {");
        ret.append("          int " + JVector.getId("len") + " = " + fname + ".size();\n");
        ret.append("          for(int " + JVector.getId("vidx") + " = 0; " + JVector.getId("vidx") + "<" + JVector.getId("len") + "; " + JVector.getId("vidx") + "++) {\n");
        ret.append("            " + this.mElement.getJavaWrapperType() + " " + JVector.getId("e") + " = (" + this.mElement.getJavaWrapperType() + ") " + fname + ".get(" + JVector.getId("vidx") + ");\n");
        ret.append(this.mElement.genJavaWriteWrapper(JVector.getId("e"), JVector.getId("e")));
        ret.append("          }\n");
        ret.append("      }\n");
        ret.append("      a_.endVector(" + fname + ",\"" + tag + "\");\n");
        ret.append("    }\n");
        JVector.decrLevel();
        return ret.toString();
    }

    public String genJavaWriteMethod(String fname, String tag) {
        return this.genJavaWriteWrapper(fname, tag);
    }

    public JType getElementType() {
        return this.mElement;
    }

    public static String extractVectorName(JType jvType) {
        return JRecord.extractMethodSuffix(jvType) + "_vector";
    }
}

