/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientWatchManager;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.proto.AuthPacket;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.ExistsResponse;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.GetChildrenResponse;
import org.apache.zookeeper.proto.GetDataResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.SetACLResponse;
import org.apache.zookeeper.proto.SetDataResponse;
import org.apache.zookeeper.proto.SetWatches;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.ZooTrace;

public class ClientCnxn {
    private static final Logger LOG = Logger.getLogger(ClientCnxn.class);
    public static boolean disableAutoWatchReset = Boolean.getBoolean("zookeeper.disableAutoWatchReset");
    private ArrayList<InetSocketAddress> serverAddrs = new ArrayList();
    private ArrayList<AuthData> authInfo = new ArrayList();
    private LinkedList<Packet> pendingQueue = new LinkedList();
    private LinkedList<Packet> outgoingQueue = new LinkedList();
    private int nextAddrToTry = 0;
    private int connectTimeout;
    private int readTimeout;
    private final int sessionTimeout;
    private final ZooKeeper zooKeeper;
    private final ClientWatchManager watcher;
    private long sessionId;
    private byte[] sessionPasswd = new byte[16];
    final SendThread sendThread;
    final EventThread eventThread;
    final Selector selector = Selector.open();
    volatile boolean closing = false;
    Object eventOfDeath = new Object();
    static final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    volatile long lastZxid;
    private int xid = 1;

    public long getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionPasswd() {
        return this.sessionPasswd;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("sessionId: 0x").append(Long.toHexString(this.getSessionId())).append("\n");
        sb.append("lastZxid: ").append(this.lastZxid).append("\n");
        sb.append("xid: ").append(this.xid).append("\n");
        sb.append("nextAddrToTry: ").append(this.nextAddrToTry).append("\n");
        sb.append("serverAddrs: ").append(this.serverAddrs.get(this.nextAddrToTry)).append("\n");
        return sb.toString();
    }

    public ClientCnxn(String hosts, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher) throws IOException {
        this(hosts, sessionTimeout, zooKeeper, watcher, 0L, new byte[16]);
    }

    public ClientCnxn(String hosts, int sessionTimeout, ZooKeeper zooKeeper, ClientWatchManager watcher, long sessionId, byte[] sessionPasswd) throws IOException {
        String[] hostsList;
        this.zooKeeper = zooKeeper;
        this.watcher = watcher;
        this.sessionId = sessionId;
        this.sessionPasswd = sessionPasswd;
        for (String host : hostsList = hosts.split(",")) {
            InetAddress[] addrs;
            int port = 2181;
            String[] parts = host.split(":");
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
                host = parts[0];
            }
            for (InetAddress addr : addrs = InetAddress.getAllByName(host)) {
                this.serverAddrs.add(new InetSocketAddress(addr, port));
            }
        }
        this.sessionTimeout = sessionTimeout;
        this.connectTimeout = sessionTimeout / hostsList.length;
        this.readTimeout = sessionTimeout * 2 / 3;
        Collections.shuffle(this.serverAddrs);
        this.sendThread = new SendThread();
        this.eventThread = new EventThread();
        this.sendThread.start();
        this.eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPacket(Packet p) {
        if (p.watchRegistration != null) {
            p.watchRegistration.register(p.replyHeader.getErr());
        }
        if (p.cb == null) {
            Packet packet = p;
            synchronized (packet) {
                p.finished = true;
                p.notifyAll();
            }
        } else {
            p.finished = true;
            this.eventThread.queuePacket(p);
        }
    }

    private void conLossPacket(Packet p) {
        if (p.replyHeader == null) {
            return;
        }
        switch (this.zooKeeper.state) {
            case AUTH_FAILED: {
                p.replyHeader.setErr(-115);
                break;
            }
            case CLOSED: {
                p.replyHeader.setErr(-112);
                break;
            }
            default: {
                p.replyHeader.setErr(-4);
            }
        }
        this.finishPacket(p);
    }

    public void disconnect() {
        LOG.info((Object)("Disconnecting ClientCnxn for session: 0x" + Long.toHexString(this.getSessionId())));
        this.sendThread.close();
        this.eventThread.queueEventOfDeath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LOG.info((Object)("Closing ClientCnxn for session: 0x" + Long.toHexString(this.getSessionId())));
        this.closing = true;
        try {
            RequestHeader h = new RequestHeader();
            h.setType(-11);
            this.submitRequest(h, null, null, null);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.disconnect();
        }
    }

    private synchronized int getXid() {
        return this.xid++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyHeader submitRequest(RequestHeader h, Record request, Record response, ZooKeeper.WatchRegistration watchRegistration) throws InterruptedException {
        Packet packet;
        ReplyHeader r = new ReplyHeader();
        Packet packet2 = packet = this.queuePacket(h, r, request, response, null, null, null, watchRegistration);
        synchronized (packet2) {
            while (!packet.finished) {
                packet.wait();
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet queuePacket(RequestHeader h, ReplyHeader r, Record request, Record response, AsyncCallback cb, String path, Object ctx, ZooKeeper.WatchRegistration watchRegistration) {
        Packet packet = null;
        Object object = this.outgoingQueue;
        synchronized (object) {
            if (h.getType() != 11 && h.getType() != 100) {
                h.setXid(this.getXid());
            }
            packet = new Packet(h, r, request, response, null, watchRegistration);
            packet.cb = cb;
            packet.ctx = ctx;
            packet.path = path;
            if (!this.zooKeeper.state.isAlive()) {
                this.conLossPacket(packet);
            } else {
                this.outgoingQueue.add(packet);
            }
        }
        object = this.sendThread;
        synchronized (object) {
            this.selector.wakeup();
        }
        return packet;
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        this.authInfo.add(new AuthData(scheme, auth));
        if (this.zooKeeper.state == ZooKeeper.States.CONNECTED) {
            this.queuePacket(new RequestHeader(-4, 100), null, new AuthPacket(0, scheme, auth), null, null, null, null, null);
        }
    }

    static /* synthetic */ byte[] access$902(ClientCnxn x0, byte[] x1) {
        x0.sessionPasswd = x1;
        return x1;
    }

    static {
        LOG.info((Object)("zookeeper.disableAutoWatchReset is " + disableAutoWatchReset));
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                LOG.error((Object)("from " + t.getName()), e);
            }
        };
    }

    class SendThread
    extends Thread {
        SelectionKey sockKey;
        ByteBuffer lenBuffer;
        ByteBuffer incomingBuffer;
        boolean initialized;
        int lastConnectIndex;
        int currentConnectIndex;
        Random r;

        void readLength() throws IOException {
            int len = this.incomingBuffer.getInt();
            if (len < 0 || len >= 0x400000) {
                throw new IOException("Packet len" + len + " is out of range!");
            }
            this.incomingBuffer = ByteBuffer.allocate(len);
        }

        void readConnectResult() throws IOException {
            ByteBufferInputStream bbis = new ByteBufferInputStream(this.incomingBuffer);
            BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
            ConnectResponse conRsp = new ConnectResponse();
            conRsp.deserialize(bbia, "connect");
            int sessionTimeout = conRsp.getTimeOut();
            if (sessionTimeout <= 0) {
                ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CLOSED;
                ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
                throw new IOException("Session Expired");
            }
            ClientCnxn.this.readTimeout = sessionTimeout * 2 / 3;
            ClientCnxn.this.connectTimeout = sessionTimeout / ClientCnxn.this.serverAddrs.size();
            ClientCnxn.this.sessionId = conRsp.getSessionId();
            ClientCnxn.access$902(ClientCnxn.this, conRsp.getPasswd());
            ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.SyncConnected, null));
            if (!disableAutoWatchReset) {
                SetWatches sw = new SetWatches(ClientCnxn.this.lastZxid, ClientCnxn.this.zooKeeper.getDataWatches(), ClientCnxn.this.zooKeeper.getExistWatches(), ClientCnxn.this.zooKeeper.getChildWatches());
                RequestHeader h = new RequestHeader();
                h.setType(101);
                ClientCnxn.this.queuePacket(h, new ReplyHeader(), sw, null, null, null, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readResponse() throws IOException {
            ByteBufferInputStream bbis = new ByteBufferInputStream(this.incomingBuffer);
            BinaryInputArchive bbia = BinaryInputArchive.getArchive(bbis);
            ReplyHeader replyHdr = new ReplyHeader();
            replyHdr.deserialize(bbia, "header");
            if (replyHdr.getXid() == -2) {
                LOG.debug((Object)("Got ping sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId)));
                return;
            }
            if (replyHdr.getXid() == -4) {
                LOG.debug((Object)("Got auth sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId)));
                return;
            }
            if (replyHdr.getXid() == -1) {
                LOG.debug((Object)("Got notification sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId)));
                WatcherEvent event = new WatcherEvent();
                event.deserialize(bbia, "response");
                WatchedEvent we = new WatchedEvent(event);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got " + we + " for sessionid 0x" + Long.toHexString(ClientCnxn.this.sessionId)));
                }
                ClientCnxn.this.eventThread.queueEvent(we);
                return;
            }
            if (ClientCnxn.this.pendingQueue.size() == 0) {
                throw new IOException("Nothing in the queue, but got " + replyHdr.getXid());
            }
            Packet packet = null;
            LinkedList linkedList = ClientCnxn.this.pendingQueue;
            synchronized (linkedList) {
                packet = (Packet)ClientCnxn.this.pendingQueue.remove();
            }
            try {
                if (packet.header.getXid() != replyHdr.getXid()) {
                    packet.replyHeader.setErr(-4);
                    throw new IOException("Xid out of order. Got " + replyHdr.getXid() + " expected " + packet.header.getXid());
                }
                packet.replyHeader.setXid(replyHdr.getXid());
                packet.replyHeader.setErr(replyHdr.getErr());
                packet.replyHeader.setZxid(replyHdr.getZxid());
                if (replyHdr.getZxid() > 0L) {
                    ClientCnxn.this.lastZxid = replyHdr.getZxid();
                }
                if (packet.response != null && replyHdr.getErr() == 0) {
                    packet.response.deserialize(bbia, "response");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reading reply sessionid:0x" + Long.toHexString(ClientCnxn.this.sessionId) + ", packet:: " + packet));
                }
            }
            finally {
                ClientCnxn.this.finishPacket(packet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean doIO() throws InterruptedException, IOException {
            boolean packetReceived = false;
            SocketChannel sock = (SocketChannel)this.sockKey.channel();
            if (sock == null) {
                throw new IOException("Socket is null!");
            }
            if (this.sockKey.isReadable()) {
                int rc = sock.read(this.incomingBuffer);
                if (rc < 0) {
                    throw new IOException("Read error rc = " + rc + " " + this.incomingBuffer);
                }
                if (this.incomingBuffer.remaining() == 0) {
                    this.incomingBuffer.flip();
                    if (this.incomingBuffer == this.lenBuffer) {
                        this.readLength();
                    } else if (!this.initialized) {
                        this.readConnectResult();
                        this.enableRead();
                        if (ClientCnxn.this.outgoingQueue.size() > 0) {
                            this.enableWrite();
                        }
                        this.lenBuffer.clear();
                        this.incomingBuffer = this.lenBuffer;
                        packetReceived = true;
                        this.initialized = true;
                    } else {
                        this.readResponse();
                        this.lenBuffer.clear();
                        this.incomingBuffer = this.lenBuffer;
                        packetReceived = true;
                    }
                }
            }
            if (this.sockKey.isWritable()) {
                LinkedList linkedList = ClientCnxn.this.outgoingQueue;
                synchronized (linkedList) {
                    if (ClientCnxn.this.outgoingQueue.size() > 0) {
                        sock.write(((Packet)((ClientCnxn)ClientCnxn.this).outgoingQueue.getFirst()).bb);
                        if (((Packet)((ClientCnxn)ClientCnxn.this).outgoingQueue.getFirst()).bb.remaining() == 0) {
                            Packet p = (Packet)ClientCnxn.this.outgoingQueue.removeFirst();
                            if (p.header != null && p.header.getType() != 11 && p.header.getType() != 100) {
                                ClientCnxn.this.pendingQueue.add(p);
                            }
                        }
                    }
                }
            }
            if (ClientCnxn.this.outgoingQueue.size() == 0) {
                this.disableWrite();
            } else {
                this.enableWrite();
            }
            return packetReceived;
        }

        private synchronized void enableWrite() {
            int i = this.sockKey.interestOps();
            if ((i & 4) == 0) {
                this.sockKey.interestOps(i | 4);
            }
        }

        private synchronized void disableWrite() {
            int i = this.sockKey.interestOps();
            if ((i & 4) != 0) {
                this.sockKey.interestOps(i & 0xFFFFFFFB);
            }
        }

        private synchronized void enableRead() {
            int i = this.sockKey.interestOps();
            if ((i & 1) == 0) {
                this.sockKey.interestOps(i | 1);
            }
        }

        private synchronized void disableRead() {
            int i = this.sockKey.interestOps();
            if ((i & 1) != 0) {
                this.sockKey.interestOps(i & 0xFFFFFFFE);
            }
        }

        SendThread() {
            super(SendThread.currentThread().getName() + "-SendThread");
            this.incomingBuffer = this.lenBuffer = ByteBuffer.allocateDirect(4);
            this.lastConnectIndex = -1;
            this.r = new Random(System.nanoTime());
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CONNECTING;
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void primeConnection(SelectionKey k) throws IOException {
            LOG.info((Object)("Priming connection to " + this.sockKey.channel()));
            this.lastConnectIndex = this.currentConnectIndex;
            ConnectRequest conReq = new ConnectRequest(0, ClientCnxn.this.lastZxid, ClientCnxn.this.sessionTimeout, ClientCnxn.this.sessionId, ClientCnxn.this.sessionPasswd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            boa.writeInt(-1, "len");
            conReq.serialize(boa, "connect");
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.capacity() - 4);
            bb.rewind();
            Object object = ClientCnxn.this.outgoingQueue;
            synchronized (object) {
                for (AuthData id : ClientCnxn.this.authInfo) {
                    ClientCnxn.this.outgoingQueue.addFirst(new Packet(new RequestHeader(-4, 100), null, new AuthPacket(0, id.scheme, id.data), null, null, null));
                }
                ClientCnxn.this.outgoingQueue.addFirst(new Packet(null, null, null, null, bb, null));
            }
            object = this;
            synchronized (object) {
                k.interestOps(5);
            }
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CONNECTED;
        }

        private void sendPing() {
            RequestHeader h = new RequestHeader(-2, 11);
            ClientCnxn.this.queuePacket(h, null, null, null, null, null, null, null);
        }

        private void startConnect() throws IOException {
            if (this.lastConnectIndex == -1) {
                this.lastConnectIndex = 0;
            } else {
                try {
                    Thread.sleep(this.r.nextInt(1000));
                }
                catch (InterruptedException e1) {
                    LOG.warn((Object)"Unexpected exception", (Throwable)e1);
                }
                if (ClientCnxn.this.nextAddrToTry == this.lastConnectIndex) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Unexpected exception", (Throwable)e);
                    }
                }
            }
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CONNECTING;
            this.currentConnectIndex = ClientCnxn.this.nextAddrToTry;
            InetSocketAddress addr = (InetSocketAddress)ClientCnxn.this.serverAddrs.get(ClientCnxn.this.nextAddrToTry);
            ClientCnxn.this.nextAddrToTry++;
            if (ClientCnxn.this.nextAddrToTry == ClientCnxn.this.serverAddrs.size()) {
                ClientCnxn.this.nextAddrToTry = 0;
            }
            SocketChannel sock = SocketChannel.open();
            sock.configureBlocking(false);
            sock.socket().setSoLinger(false, -1);
            sock.socket().setTcpNoDelay(true);
            LOG.info((Object)("Attempting connection to server " + addr));
            this.sockKey = sock.register(ClientCnxn.this.selector, 8);
            if (sock.connect(addr)) {
                this.primeConnection(this.sockKey);
            }
            this.initialized = false;
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long now;
            long lastHeard = now = System.currentTimeMillis();
            long lastSend = now;
            while (((ClientCnxn)ClientCnxn.this).zooKeeper.state.isAlive()) {
                try {
                    Set<SelectionKey> selected;
                    if (this.sockKey == null) {
                        if (ClientCnxn.this.closing) break;
                        this.startConnect();
                        lastSend = now;
                        lastHeard = now;
                    }
                    int idleRecv = (int)(now - lastHeard);
                    int idleSend = (int)(now - lastSend);
                    int to = ClientCnxn.this.readTimeout - idleRecv;
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state != ZooKeeper.States.CONNECTED) {
                        to = ClientCnxn.this.connectTimeout - idleRecv;
                    }
                    if (to <= 0) {
                        throw new IOException("TIMED OUT");
                    }
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state == ZooKeeper.States.CONNECTED) {
                        int timeToNextPing = ClientCnxn.this.readTimeout / 2 - idleSend;
                        if (timeToNextPing <= 0) {
                            this.sendPing();
                            lastSend = now;
                            this.enableWrite();
                        } else if (timeToNextPing < to) {
                            to = timeToNextPing;
                        }
                    }
                    ClientCnxn.this.selector.select(to);
                    SendThread sendThread = this;
                    synchronized (sendThread) {
                        selected = ClientCnxn.this.selector.selectedKeys();
                    }
                    now = System.currentTimeMillis();
                    for (SelectionKey k : selected) {
                        SocketChannel sc = (SocketChannel)k.channel();
                        if ((k.readyOps() & 8) != 0) {
                            if (!sc.finishConnect()) continue;
                            lastHeard = now;
                            lastSend = now;
                            this.primeConnection(k);
                            LOG.info((Object)"Server connection successful");
                            continue;
                        }
                        if ((k.readyOps() & 5) == 0) continue;
                        if (ClientCnxn.this.outgoingQueue.size() > 0) {
                            lastSend = now;
                        }
                        if (!this.doIO()) continue;
                        lastHeard = now;
                    }
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state == ZooKeeper.States.CONNECTED) {
                        if (ClientCnxn.this.outgoingQueue.size() > 0) {
                            this.enableWrite();
                        } else {
                            this.disableWrite();
                        }
                    }
                    selected.clear();
                }
                catch (Exception e) {
                    if (ClientCnxn.this.closing) {
                        LOG.info((Object)("Exception while closing send thread for session 0x" + Long.toHexString(ClientCnxn.this.getSessionId()) + " : " + e.getMessage()));
                        break;
                    }
                    LOG.warn((Object)("Exception closing session 0x" + Long.toHexString(ClientCnxn.this.getSessionId()) + " to " + this.sockKey), (Throwable)e);
                    this.cleanup();
                    if (((ClientCnxn)ClientCnxn.this).zooKeeper.state.isAlive()) {
                        ClientCnxn.this.eventThread.queueEvent(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
                    }
                    lastHeard = now = System.currentTimeMillis();
                    lastSend = now;
                }
            }
            this.cleanup();
            try {
                ClientCnxn.this.selector.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Ignoring exception during selector close", (Throwable)e);
            }
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "SendThread exitedloop.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            if (this.sockKey != null) {
                SocketChannel sock = (SocketChannel)this.sockKey.channel();
                this.sockKey.cancel();
                try {
                    sock.socket().shutdownInput();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Ignoring exception during shutdown input", (Throwable)e);
                }
                try {
                    sock.socket().shutdownOutput();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Ignoring exception during shutdown output", (Throwable)e);
                }
                try {
                    sock.socket().close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Ignoring exception during socket close", (Throwable)e);
                }
                try {
                    sock.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Ignoring exception during channel close", (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"SendThread interrupted during sleep, ignoring");
            }
            this.sockKey = null;
            LinkedList linkedList = ClientCnxn.this.pendingQueue;
            synchronized (linkedList) {
                for (Packet p : ClientCnxn.this.pendingQueue) {
                    ClientCnxn.this.conLossPacket(p);
                }
                ClientCnxn.this.pendingQueue.clear();
            }
            linkedList = ClientCnxn.this.outgoingQueue;
            synchronized (linkedList) {
                for (Packet p : ClientCnxn.this.outgoingQueue) {
                    ClientCnxn.this.conLossPacket(p);
                }
                ClientCnxn.this.outgoingQueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            ((ClientCnxn)ClientCnxn.this).zooKeeper.state = ZooKeeper.States.CLOSED;
            SendThread sendThread = this;
            synchronized (sendThread) {
                ClientCnxn.this.selector.wakeup();
            }
        }
    }

    class EventThread
    extends Thread {
        private final LinkedBlockingQueue<Object> waitingEvents;

        EventThread() {
            super(EventThread.currentThread().getName() + "-EventThread");
            this.waitingEvents = new LinkedBlockingQueue();
            this.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            this.setDaemon(true);
        }

        public void queueEvent(WatchedEvent event) {
            WatcherSetEventPair pair = new WatcherSetEventPair(ClientCnxn.this.watcher.materialize(event.getState(), event.getType(), event.getPath()), event);
            this.waitingEvents.add(pair);
        }

        public void queuePacket(Packet packet) {
            this.waitingEvents.add(packet);
        }

        public void queueEventOfDeath() {
            this.waitingEvents.add(ClientCnxn.this.eventOfDeath);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
lbl1:
            // 2 sources

            try {
                while ((event = this.waitingEvents.take()) != ClientCnxn.this.eventOfDeath) {
                    block18: {
                        if (!(event instanceof WatcherSetEventPair)) break block18;
                        pair = (WatcherSetEventPair)event;
                        for (Watcher watcher : WatcherSetEventPair.access$200(pair)) {
                            watcher.process(WatcherSetEventPair.access$300(pair));
                        }
                        ** GOTO lbl1
                    }
                    p = (Packet)event;
                    rc = 0;
                    path = p.path;
                    if (p.replyHeader.getErr() != 0) {
                        rc = p.replyHeader.getErr();
                    }
                    if (p.cb == null) {
                        ClientCnxn.access$000().warn((Object)"Somehow a null cb got to EventThread!");
                        continue;
                    }
                    if (p.response instanceof ExistsResponse || p.response instanceof SetDataResponse || p.response instanceof SetACLResponse) {
                        cb = (AsyncCallback.StatCallback)p.cb;
                        if (rc == 0) {
                            if (p.response instanceof ExistsResponse) {
                                cb.processResult(rc, path, p.ctx, ((ExistsResponse)p.response).getStat());
                                continue;
                            }
                            if (p.response instanceof SetDataResponse) {
                                cb.processResult(rc, path, p.ctx, ((SetDataResponse)p.response).getStat());
                                continue;
                            }
                            if (!(p.response instanceof SetACLResponse)) continue;
                            cb.processResult(rc, path, p.ctx, ((SetACLResponse)p.response).getStat());
                            continue;
                        }
                        cb.processResult(rc, path, p.ctx, null);
                        continue;
                    }
                    if (p.response instanceof GetDataResponse) {
                        cb = (AsyncCallback.DataCallback)p.cb;
                        rsp = (GetDataResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, path, p.ctx, rsp.getData(), rsp.getStat());
                            continue;
                        }
                        cb.processResult(rc, path, p.ctx, null, null);
                        continue;
                    }
                    if (p.response instanceof GetACLResponse) {
                        cb = (AsyncCallback.ACLCallback)p.cb;
                        rsp = (GetACLResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, path, p.ctx, rsp.getAcl(), rsp.getStat());
                            continue;
                        }
                        cb.processResult(rc, path, p.ctx, null, null);
                        continue;
                    }
                    if (p.response instanceof GetChildrenResponse) {
                        cb = (AsyncCallback.ChildrenCallback)p.cb;
                        rsp = (GetChildrenResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, path, p.ctx, rsp.getChildren());
                            continue;
                        }
                        cb.processResult(rc, path, p.ctx, null);
                        continue;
                    }
                    if (p.response instanceof CreateResponse) {
                        cb = (AsyncCallback.StringCallback)p.cb;
                        rsp = (CreateResponse)p.response;
                        if (rc == 0) {
                            cb.processResult(rc, path, p.ctx, rsp.getPath());
                            continue;
                        }
                        cb.processResult(rc, path, p.ctx, null);
                        continue;
                    }
                    if (!(p.cb instanceof AsyncCallback.VoidCallback)) continue;
                    cb = (AsyncCallback.VoidCallback)p.cb;
                    cb.processResult(rc, path, p.ctx);
                }
            }
            catch (InterruptedException e) {
                ClientCnxn.access$000().warn((Object)"Event thread exiting due to interruption", (Throwable)e);
            }
            ClientCnxn.access$000().info((Object)"EventThread shut down");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WatcherSetEventPair {
        private final Set<Watcher> watchers;
        private final WatchedEvent event;

        public WatcherSetEventPair(Set<Watcher> watchers, WatchedEvent event) {
            this.watchers = watchers;
            this.event = event;
        }

        static /* synthetic */ Set access$200(WatcherSetEventPair x0) {
            return x0.watchers;
        }

        static /* synthetic */ WatchedEvent access$300(WatcherSetEventPair x0) {
            return x0.event;
        }
    }

    static class Packet {
        RequestHeader header;
        ByteBuffer bb;
        String path;
        ReplyHeader replyHeader;
        Record request;
        Record response;
        boolean finished;
        AsyncCallback cb;
        Object ctx;
        ZooKeeper.WatchRegistration watchRegistration;

        Packet(RequestHeader header, ReplyHeader replyHeader, Record record, Record response, ByteBuffer bb, ZooKeeper.WatchRegistration watchRegistration) {
            this.header = header;
            this.replyHeader = replyHeader;
            this.request = record;
            this.response = response;
            if (bb != null) {
                this.bb = bb;
            } else {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
                    boa.writeInt(-1, "len");
                    header.serialize(boa, "header");
                    if (record != null) {
                        record.serialize(boa, "request");
                    }
                    baos.close();
                    this.bb = ByteBuffer.wrap(baos.toByteArray());
                    this.bb.putInt(this.bb.capacity() - 4);
                    this.bb.rewind();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Unexpected exception", (Throwable)e);
                }
            }
            this.watchRegistration = watchRegistration;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("path:" + this.path);
            sb.append(" finished:" + this.finished);
            sb.append(" header:: " + this.header);
            sb.append(" replyHeader:: " + this.replyHeader);
            sb.append(" request:: " + this.request);
            sb.append(" response:: " + this.response);
            return sb.toString().replaceAll("\r*\n+", " ");
        }
    }

    static class AuthData {
        String scheme;
        byte[] data;

        AuthData(String scheme, byte[] data) {
            this.scheme = scheme;
            this.data = data;
        }
    }
}

