/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperMain {
    private static AsyncCallback.DataCallback dataCallback = new AsyncCallback.DataCallback(){

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            System.out.println("rc = " + rc + " path = " + path + " data = " + (data == null ? "null" : new String(data)) + " stat = ");
            ZooKeeperMain.printStat(stat);
        }
    };

    static void usage() {
        System.err.println("ZooKeeper host:port cmd args");
        System.err.println("\tcreate path data acl");
        System.err.println("\tdelete path [version]");
        System.err.println("\tset path data [version]");
        System.err.println("\tget path [watch]");
        System.err.println("\tls path [watch]");
        System.err.println("\tgetAcl path");
        System.err.println("\tsetAcl path acl");
        System.err.println("\tstat path [watch]");
        System.err.println("\tsync path");
    }

    private static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    System.err.println("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    private static void printStat(Stat stat) {
        System.err.println("cZxid = " + stat.getCzxid());
        System.err.println("ctime = " + new Date(stat.getCtime()).toString());
        System.err.println("mZxid = " + stat.getMzxid());
        System.err.println("mtime = " + new Date(stat.getMtime()).toString());
        System.err.println("pZxid = " + stat.getPzxid());
        System.err.println("cversion = " + stat.getCversion());
        System.err.println("dataVersion = " + stat.getVersion());
        System.err.println("aclVersion = " + stat.getAversion());
        System.err.println("ephemeralOwner = " + stat.getEphemeralOwner());
        System.err.println("dataLength = " + stat.getDataLength());
        System.err.println("numChildren = " + stat.getNumChildren());
    }

    public static void main(String[] args) throws NumberFormatException, KeeperException, IOException, InterruptedException {
        boolean watch;
        ZooKeeper zooKeeper;
        if (args.length == 1) {
            String line;
            zooKeeper = new ZooKeeper(args[0], 5000, new MyWatcher());
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((line = br.readLine()) != null) {
                line = "ignore " + line;
                args = line.split(" ");
                ZooKeeperMain.processCmd(args, zooKeeper);
            }
        } else if (args.length < 3) {
            ZooKeeperMain.usage();
        }
        if (!(watch = ZooKeeperMain.processCmd(args, zooKeeper = new ZooKeeper(args[0], 5000, new MyWatcher())))) {
            System.exit(0);
        }
    }

    private static boolean processCmd(String[] args, ZooKeeper zooKeeper) throws KeeperException, IOException, InterruptedException {
        Stat stat = new Stat();
        if (args.length < 2) {
            return false;
        }
        if (args.length < 3) {
            ZooKeeperMain.usage();
            return false;
        }
        String cmd = args[1];
        boolean watch = args.length > 3;
        String path = args[2];
        List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        System.out.println("Processing " + cmd);
        if (cmd.equals("create") && args.length >= 4) {
            if (args.length == 5) {
                acl = ZooKeeperMain.parseACLs(args[4]);
            }
            String newPath = zooKeeper.create(path, args[3].getBytes(), acl, CreateMode.PERSISTENT);
            System.err.println("Created " + newPath);
        } else if (cmd.equals("delete") && args.length >= 3) {
            zooKeeper.delete(path, watch ? Integer.parseInt(args[3]) : -1);
        } else if (cmd.equals("set") && args.length >= 4) {
            stat = zooKeeper.setData(path, args[3].getBytes(), args.length > 4 ? Integer.parseInt(args[4]) : -1);
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("aget") && args.length >= 3) {
            zooKeeper.getData(path, watch, dataCallback, (Object)path);
        } else if (cmd.equals("get") && args.length >= 3) {
            byte[] data = zooKeeper.getData(path, watch, stat);
            System.out.println(new String(data));
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("ls") && args.length >= 3) {
            List<String> children = zooKeeper.getChildren(path, watch);
            System.out.println(children);
        } else if (cmd.equals("getAcl") && args.length >= 2) {
            acl = zooKeeper.getACL(path, stat);
            for (ACL a : acl) {
                System.out.println(a.getId() + ": " + ZooKeeperMain.getPermString(a.getPerms()));
            }
        } else if (cmd.equals("setAcl") && args.length >= 4) {
            stat = zooKeeper.setACL(path, ZooKeeperMain.parseACLs(args[3]), args.length > 4 ? Integer.parseInt(args[4]) : -1);
            ZooKeeperMain.printStat(stat);
        } else if (cmd.equals("stat") && args.length >= 3) {
            stat = zooKeeper.exists(path, watch);
            ZooKeeperMain.printStat(stat);
        } else {
            ZooKeeperMain.usage();
        }
        return watch;
    }

    private static String getPermString(int perms) {
        StringBuffer p = new StringBuffer();
        if ((perms & 4) != 0) {
            p.append('c');
        }
        if ((perms & 8) != 0) {
            p.append('d');
        }
        if ((perms & 1) != 0) {
            p.append('r');
        }
        if ((perms & 2) != 0) {
            p.append('w');
        }
        if ((perms & 0x10) != 0) {
            p.append('a');
        }
        return p.toString();
    }

    private static List<ACL> parseACLs(String aclString) {
        String[] acls = aclString.split(",");
        ArrayList<ACL> acl = new ArrayList<ACL>();
        for (String a : acls) {
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                System.err.println(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZooKeeperMain.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    private static class MyWatcher
    implements Watcher {
        private MyWatcher() {
        }

        public void process(WatchedEvent event) {
            System.err.println(event);
        }
    }
}

