/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.proto.AuthPacket;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.ProviderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOServerCnxn
implements Watcher,
ServerCnxn {
    private static final Logger LOG = Logger.getLogger(NIOServerCnxn.class);
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    Factory factory;
    ZooKeeperServer zk;
    private SocketChannel sock;
    private SelectionKey sk;
    boolean initialized;
    ByteBuffer lenBuffer;
    ByteBuffer incomingBuffer;
    LinkedBlockingQueue<ByteBuffer> outgoingBuffers;
    int sessionTimeout;
    ArrayList<Id> authInfo;
    LinkedList<Request> outstanding;
    int outstandingRequests;
    long sessionId;
    static long nextSessionId = 1L;
    boolean closed;
    private static final byte[] fourBytes = new byte[4];
    private CnxnStats stats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBuffer(ByteBuffer bb) {
        Factory factory = this.factory;
        synchronized (factory) {
            try {
                this.sk.selector().wakeup();
                this.outgoingBuffers.add(bb);
                if (this.sk.isValid()) {
                    this.sk.interestOps(this.sk.interestOps() | 4);
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)"FIXMSG", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIO(SelectionKey k) throws InterruptedException {
        block23: {
            try {
                if (this.sock == null) {
                    return;
                }
                if (k.isReadable()) {
                    int rc = this.sock.read(this.incomingBuffer);
                    if (rc < 0) {
                        throw new IOException("Read error");
                    }
                    if (this.incomingBuffer.remaining() == 0) {
                        this.incomingBuffer.flip();
                        if (this.incomingBuffer == this.lenBuffer) {
                            this.readLength(k);
                        } else if (!this.initialized) {
                            ++this.stats.packetsReceived;
                            ServerStats.getInstance().incrementPacketsReceived();
                            this.readConnectRequest();
                            this.lenBuffer.clear();
                            this.incomingBuffer = this.lenBuffer;
                        } else {
                            ++this.stats.packetsReceived;
                            ServerStats.getInstance().incrementPacketsReceived();
                            this.readRequest();
                            this.lenBuffer.clear();
                            this.incomingBuffer = this.lenBuffer;
                        }
                    }
                }
                if (!k.isWritable()) break block23;
                if (this.outgoingBuffers.size() > 0) {
                    ByteBuffer directBuffer = this.factory.directBuffer;
                    directBuffer.clear();
                    for (ByteBuffer b : this.outgoingBuffers) {
                        if (directBuffer.remaining() < b.remaining()) {
                            b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                        }
                        int p = b.position();
                        directBuffer.put(b);
                        b.position(p);
                        if (directBuffer.remaining() != 0) continue;
                        break;
                    }
                    directBuffer.flip();
                    int sent = this.sock.write(directBuffer);
                    while (this.outgoingBuffers.size() > 0) {
                        ByteBuffer bb = this.outgoingBuffers.peek();
                        if (bb == closeConn) {
                            throw new IOException("closing");
                        }
                        int left = bb.remaining() - sent;
                        if (left > 0) {
                            bb.position(bb.position() + sent);
                            break;
                        }
                        ++this.stats.packetsSent;
                        sent -= bb.remaining();
                        ServerStats.getInstance().incrementPacketsSent();
                        this.outgoingBuffers.remove();
                    }
                }
                NIOServerCnxn directBuffer = this;
                synchronized (directBuffer) {
                    if (this.outgoingBuffers.size() == 0) {
                        if (!this.initialized && (this.sk.interestOps() & 1) == 0) {
                            throw new IOException("Responded to info probe");
                        }
                        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFB);
                    } else {
                        this.sk.interestOps(this.sk.interestOps() | 4);
                    }
                }
            }
            catch (CancelledKeyException e) {
                this.close();
            }
            catch (IOException e) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRequest() throws IOException {
        ByteBufferInputStream bais = new ByteBufferInputStream(this.incomingBuffer);
        BinaryInputArchive bia = BinaryInputArchive.getArchive(bais);
        RequestHeader h = new RequestHeader();
        h.deserialize(bia, "header");
        this.incomingBuffer = this.incomingBuffer.slice();
        if (h.getType() == 100) {
            AuthPacket authPacket = new AuthPacket();
            ZooKeeperServer.byteBuffer2Record(this.incomingBuffer, authPacket);
            String scheme = authPacket.getScheme();
            AuthenticationProvider ap = ProviderRegistry.getProvider(scheme);
            if (ap == null || ap.handleAuthentication(this, authPacket.getAuth()) != 0) {
                if (ap == null) {
                    LOG.error((Object)("No authentication provider for scheme: " + scheme + " has " + ProviderRegistry.listProviders()));
                } else {
                    LOG.debug((Object)("Authentication failed for scheme: " + scheme));
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, -115);
                this.sendResponse(rh, null, null);
                this.sendBuffer(closeConn);
                this.disableRecv();
            } else {
                LOG.debug((Object)("Authentication succeeded for scheme: " + scheme));
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, 0);
                this.sendResponse(rh, null, null);
            }
            return;
        }
        this.zk.submitRequest(this, this.sessionId, h.getType(), h.getXid(), this.incomingBuffer, this.authInfo);
        if (h.getXid() >= 0) {
            NIOServerCnxn nIOServerCnxn = this;
            synchronized (nIOServerCnxn) {
                ++this.outstandingRequests;
                if (this.zk.getInProcess() > this.factory.outstandingLimit) {
                    LOG.warn((Object)("Throttling recv " + this.zk.getInProcess()));
                    this.disableRecv();
                }
            }
        }
    }

    public void disableRecv() {
        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFE);
    }

    public void enableRecv() {
        int interest;
        if (this.sk.isValid() && ((interest = this.sk.interestOps()) & 1) == 0) {
            this.sk.interestOps(interest | 1);
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException {
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(this.incomingBuffer));
        ConnectRequest connReq = new ConnectRequest();
        connReq.deserialize(bia, "connect");
        LOG.warn((Object)("Connected to " + this.sock.socket().getRemoteSocketAddress() + " lastZxid " + connReq.getLastZxidSeen()));
        if (this.zk == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        if (connReq.getLastZxidSeen() > this.zk.dataTree.lastProcessedZxid) {
            LOG.error((Object)("Client has seen zxid 0x" + Long.toHexString(connReq.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.zk.dataTree.lastProcessedZxid)));
            throw new IOException("We are out of date");
        }
        this.sessionTimeout = connReq.getTimeOut();
        byte[] passwd = connReq.getPasswd();
        if (this.sessionTimeout < this.zk.tickTime * 2) {
            this.sessionTimeout = this.zk.tickTime * 2;
        }
        if (this.sessionTimeout > this.zk.tickTime * 20) {
            this.sessionTimeout = this.zk.tickTime * 20;
        }
        this.disableRecv();
        if (connReq.getSessionId() != 0L) {
            this.setSessionId(connReq.getSessionId());
            this.zk.reopenSession(this, this.sessionId, passwd, this.sessionTimeout);
            LOG.warn((Object)("Renewing session 0x" + Long.toHexString(this.sessionId)));
        } else {
            this.zk.createSession(this, passwd, this.sessionTimeout);
            LOG.warn((Object)("Creating new session 0x" + Long.toHexString(this.sessionId)));
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized) {
            if (len == ruokCmd) {
                this.sendBuffer(imok.duplicate());
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == killCmd) {
                System.exit(0);
            } else {
                if (len == getTraceMaskCmd) {
                    long traceMask = ZooTrace.getTextTraceLevel();
                    ByteBuffer resp = ByteBuffer.allocate(8);
                    resp.putLong(traceMask);
                    resp.flip();
                    this.sendBuffer(resp);
                    this.sendBuffer(closeConn);
                    k.interestOps(4);
                    return;
                }
                if (len == setTraceMaskCmd) {
                    this.incomingBuffer = ByteBuffer.allocate(8);
                    int rc = this.sock.read(this.incomingBuffer);
                    if (rc < 0) {
                        throw new IOException("Read error");
                    }
                    System.out.println("rc=" + rc);
                    this.incomingBuffer.flip();
                    long traceMask = this.incomingBuffer.getLong();
                    ZooTrace.setTextTraceLevel(traceMask);
                    ByteBuffer resp = ByteBuffer.allocate(8);
                    resp.putLong(traceMask);
                    resp.flip();
                    this.sendBuffer(resp);
                    this.sendBuffer(closeConn);
                    k.interestOps(4);
                    return;
                }
                if (len == dumpCmd) {
                    if (this.zk == null) {
                        this.sendBuffer(ByteBuffer.wrap("ZooKeeper not active \n".getBytes()));
                    } else {
                        StringBuffer sb = new StringBuffer();
                        sb.append("SessionTracker dump: \n");
                        sb.append(this.zk.sessionTracker.toString()).append("\n");
                        sb.append("ephemeral nodes dump:\n");
                        sb.append(this.zk.dataTree.dumpEphemerals()).append("\n");
                        this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                    }
                    k.interestOps(4);
                    return;
                }
                if (len == reqsCmd) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Requests:\n");
                    LinkedList<Request> linkedList = this.outstanding;
                    synchronized (linkedList) {
                        for (Request r : this.outstanding) {
                            sb.append(r.toString());
                            sb.append('\n');
                        }
                    }
                    this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                    k.interestOps(4);
                    return;
                }
                if (len == statCmd) {
                    StringBuffer sb = new StringBuffer();
                    if (this.zk != null) {
                        sb.append("Zookeeper version: ").append(Version.getFullVersion()).append("\n");
                        sb.append("Clients:\n");
                        HashSet<NIOServerCnxn> hashSet = this.factory.cnxns;
                        synchronized (hashSet) {
                            for (NIOServerCnxn c : this.factory.cnxns) {
                                sb.append(c.getStats().toString());
                            }
                        }
                        sb.append("\n");
                        sb.append(ServerStats.getInstance().toString());
                        sb.append("Node count: ").append(this.zk.dataTree.getNodeCount()).append("\n");
                    } else {
                        sb.append("ZooKeeperServer not running\n");
                    }
                    this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                    k.interestOps(4);
                    return;
                }
            }
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (this.zk == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, Factory factory) throws IOException {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue();
        this.authInfo = new ArrayList();
        this.outstanding = new LinkedList();
        this.stats = new CnxnStats();
        this.zk = zk;
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(true, 2);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.authInfo.add(new Id("ip", addr.getHostAddress()));
        this.authInfo.add(new Id("host", addr.getCanonicalHostName()));
        sk.interestOps(1);
    }

    public String toString() {
        return "NIOServerCnxn object with sock = " + this.sock + " and sk = " + this.sk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        HashSet<NIOServerCnxn> hashSet = this.factory.cnxns;
        synchronized (hashSet) {
            this.factory.cnxns.remove(this);
        }
        if (this.zk != null) {
            this.zk.removeCnxn(this);
        }
        ZooTrace.logTraceMessage(LOG, 32L, "close  NIOServerCnxn: " + this.sock);
        try {
            this.sock.socket().shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.sock.socket().shutdownInput();
        }
        catch (IOException e) {
            LOG.warn((Object)"ignoring exception during input shutdown", (Throwable)e);
        }
        try {
            this.sock.socket().close();
        }
        catch (IOException e) {
            LOG.warn((Object)"ignoring exception during socket close", (Throwable)e);
        }
        try {
            this.sock.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"ignoring exception during socketchannel close", (Throwable)e);
        }
        this.sock = null;
        if (this.sk != null) {
            try {
                this.sk.cancel();
            }
            catch (Exception e) {
                LOG.warn((Object)"ignoring exception during selectionkey cancel", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendResponse(ReplyHeader h, Record r, String tag) {
        if (this.closed) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
        try {
            baos.write(fourBytes);
            bos.writeRecord(h, "header");
            if (r != null) {
                bos.writeRecord(r, tag);
            }
            baos.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error serializing response");
        }
        byte[] b = baos.toByteArray();
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(b.length - 4).rewind();
        this.sendBuffer(bb);
        if (h.getXid() > 0) {
            Factory factory = this.factory;
            synchronized (factory) {
                --this.outstandingRequests;
                if (this.zk.getInProcess() < this.factory.outstandingLimit || this.outstandingRequests < 1) {
                    this.sk.selector().wakeup();
                    this.enableRecv();
                }
            }
        }
    }

    @Override
    public synchronized void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSessionInit(boolean valid) {
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? this.sessionTimeout : 0, valid ? this.sessionId : 0L, valid ? this.zk.generatePasswd(this.sessionId) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            this.sendBuffer(bb);
            LOG.warn((Object)("Finished init of 0x" + Long.toHexString(this.sessionId) + ": " + valid));
            if (!valid) {
                this.sendBuffer(closeConn);
            }
            Factory factory = this.factory;
            synchronized (factory) {
                this.sk.selector().wakeup();
                this.enableRecv();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
            this.close();
        }
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public ArrayList<Id> getAuthInfo() {
        return this.authInfo;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    @Override
    public ServerCnxn.Stats getStats() {
        return this.stats;
    }

    private class CnxnStats
    implements ServerCnxn.Stats {
        long packetsReceived;
        long packetsSent;

        private CnxnStats() {
        }

        public long getOutstandingRequests() {
            return NIOServerCnxn.this.outstandingRequests;
        }

        public long getPacketsReceived() {
            return this.packetsReceived;
        }

        public long getPacketsSent() {
            return this.packetsSent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            SelectableChannel channel = NIOServerCnxn.this.sk.channel();
            if (channel instanceof SocketChannel) {
                sb.append(" ").append(((SocketChannel)channel).socket().getRemoteSocketAddress()).append("[").append(Integer.toHexString(NIOServerCnxn.this.sk.interestOps())).append("](queued=").append(this.getOutstandingRequests()).append(",recved=").append(this.getPacketsReceived()).append(",sent=").append(this.getPacketsSent()).append(")\n");
            }
            return sb.toString();
        }
    }

    public static class Factory
    extends Thread {
        ZooKeeperServer zks;
        ServerSocketChannel ss;
        Selector selector = Selector.open();
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(65536);
        HashSet<NIOServerCnxn> cnxns = new HashSet();
        int outstandingLimit = 1;

        public Factory(int port) throws IOException {
            super("NIOServerCxn.Factory:" + port);
            this.setDaemon(true);
            this.ss = ServerSocketChannel.open();
            this.ss.socket().bind(new InetSocketAddress(port));
            this.ss.configureBlocking(false);
            this.ss.register(this.selector, 16);
            this.start();
        }

        public void startup(ZooKeeperServer zks) throws IOException, InterruptedException {
            zks.startup();
            this.setZooKeeperServer(zks);
        }

        public void setZooKeeperServer(ZooKeeperServer zks) {
            this.zks = zks;
            if (zks != null) {
                this.outstandingLimit = zks.getGlobalOutstandingLimit();
                zks.setServerCnxnFactory(this);
            } else {
                this.outstandingLimit = 1;
            }
        }

        public ZooKeeperServer getZooKeeperServer() {
            return this.zks;
        }

        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
        }

        public int getLocalPort() {
            return this.ss.socket().getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCnxn(NIOServerCnxn cnxn) {
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                this.cnxns.add(cnxn);
            }
        }

        protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk) throws IOException {
            return new NIOServerCnxn(this.zks, sock, sk, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.ss.socket().isClosed()) {
                try {
                    Set<SelectionKey> selected;
                    this.selector.select(1000L);
                    Factory factory = this;
                    synchronized (factory) {
                        selected = this.selector.selectedKeys();
                    }
                    ArrayList<SelectionKey> selectedList = new ArrayList<SelectionKey>(selected);
                    Collections.shuffle(selectedList);
                    for (SelectionKey k : selectedList) {
                        if ((k.readyOps() & 0x10) != 0) {
                            SocketChannel sc = ((ServerSocketChannel)k.channel()).accept();
                            sc.configureBlocking(false);
                            SelectionKey sk = sc.register(this.selector, 1);
                            NIOServerCnxn cnxn = this.createConnection(sc, sk);
                            sk.attach(cnxn);
                            this.addCnxn(cnxn);
                            continue;
                        }
                        if ((k.readyOps() & 5) == 0) continue;
                        NIOServerCnxn c = (NIOServerCnxn)k.attachment();
                        c.doIO(k);
                    }
                    selected.clear();
                }
                catch (Exception e) {
                    LOG.error((Object)"FIXMSG", (Throwable)e);
                }
            }
            ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "NIOServerCnxn factory exitedloop.");
            this.clear();
            LOG.error((Object)"=====> Goodbye cruel world <======");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void clear() {
            this.selector.wakeup();
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                Iterator<NIOServerCnxn> it = this.cnxns.iterator();
                while (it.hasNext()) {
                    NIOServerCnxn cnxn = it.next();
                    it.remove();
                    try {
                        cnxn.close();
                    }
                    catch (Exception e) {}
                }
            }
        }

        public void shutdown() {
            try {
                this.ss.close();
                this.clear();
                this.interrupt();
                this.join();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected exception", (Throwable)e);
            }
            if (this.zks != null) {
                this.zks.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void closeSession(long sessionId) {
            this.selector.wakeup();
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                Iterator<NIOServerCnxn> it = this.cnxns.iterator();
                while (it.hasNext()) {
                    NIOServerCnxn cnxn = it.next();
                    if (cnxn.sessionId != sessionId) continue;
                    it.remove();
                    try {
                        cnxn.close();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"exception during session close", (Throwable)e);
                    }
                    break;
                }
            }
        }
    }
}

