/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZooTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionTrackerImpl
extends Thread
implements SessionTracker {
    private static final Logger LOG = Logger.getLogger(SessionTrackerImpl.class);
    HashMap<Long, Session> sessionsById = new HashMap();
    HashMap<Long, SessionSet> sessionSets = new HashMap();
    ConcurrentHashMap<Long, Integer> sessionsWithTimeout;
    long nextSessionId = 0L;
    long serverId;
    long nextExpirationTime;
    int expirationInterval;
    SessionTracker.SessionExpirer expirer;
    volatile boolean running = true;
    volatile long currentTime;

    public static long initializeNextSession(long id) {
        long nextSid = 0L;
        nextSid = System.currentTimeMillis() << 24 >> 8;
        return nextSid |= id << 56;
    }

    private long roundToInterval(long time) {
        return (time / (long)this.expirationInterval + 1L) * (long)this.expirationInterval;
    }

    public SessionTrackerImpl(SessionTracker.SessionExpirer expirer, ConcurrentHashMap<Long, Integer> sessionsWithTimeout, int tickTime, long sid) {
        super("SessionTracker");
        this.expirer = expirer;
        this.expirationInterval = tickTime;
        this.sessionsWithTimeout = sessionsWithTimeout;
        this.nextExpirationTime = this.roundToInterval(System.currentTimeMillis());
        this.serverId = sid;
        this.nextSessionId = SessionTrackerImpl.initializeNextSession(sid);
        Iterator i$ = sessionsWithTimeout.keySet().iterator();
        while (i$.hasNext()) {
            long id = (Long)i$.next();
            this.addSession(id, sessionsWithTimeout.get(id));
        }
        this.start();
    }

    @Override
    public synchronized String toString() {
        StringBuffer sb = new StringBuffer("Session Sets (" + this.sessionSets.size() + "):\n");
        ArrayList<Long> keys = new ArrayList<Long>(this.sessionSets.keySet());
        Collections.sort(keys);
        for (long time : keys) {
            sb.append(this.sessionSets.get((Object)Long.valueOf((long)time)).sessions.size() + " expire at " + new Date(time) + ":\n");
            for (Session s : this.sessionSets.get((Object)Long.valueOf((long)time)).sessions) {
                sb.append("\t" + s.sessionId + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public synchronized void run() {
        try {
            while (this.running) {
                this.currentTime = System.currentTimeMillis();
                if (this.nextExpirationTime > this.currentTime) {
                    this.wait(this.nextExpirationTime - this.currentTime);
                    continue;
                }
                SessionSet set = this.sessionSets.remove(this.nextExpirationTime);
                if (set != null) {
                    for (Session s : set.sessions) {
                        this.sessionsById.remove(s.sessionId);
                        LOG.warn((Object)("Expiring session 0x" + Long.toHexString(s.sessionId)));
                        this.expirer.expire(s.sessionId);
                    }
                }
                this.nextExpirationTime += (long)this.expirationInterval;
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
        }
        ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "SessionTrackerImpl exited loop!");
    }

    @Override
    public synchronized boolean touchSession(long sessionId, int timeout) {
        ZooTrace.logTraceMessage(LOG, 8L, "SessionTrackerImpl --- Touch session: 0x" + Long.toHexString(sessionId) + " with timeout " + timeout);
        Session s = this.sessionsById.get(sessionId);
        if (s == null) {
            return false;
        }
        long expireTime = this.roundToInterval(System.currentTimeMillis() + (long)timeout);
        if (s.tickTime >= expireTime) {
            return true;
        }
        SessionSet set = this.sessionSets.get(s.tickTime);
        if (set != null) {
            set.sessions.remove(s);
        }
        s.tickTime = expireTime;
        set = this.sessionSets.get(s.tickTime);
        if (set == null) {
            set = new SessionSet();
            set.expireTime = expireTime;
            this.sessionSets.put(expireTime, set);
        }
        set.sessions.add(s);
        return true;
    }

    @Override
    public synchronized void removeSession(long sessionId) {
        Session s = this.sessionsById.remove(sessionId);
        this.sessionsWithTimeout.remove(sessionId);
        ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Removing session 0x" + Long.toHexString(sessionId));
        if (s != null) {
            this.sessionSets.get((Object)Long.valueOf((long)s.tickTime)).sessions.remove(s);
        }
    }

    @Override
    public void shutdown() {
        this.running = false;
        ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "Shutdown SessionTrackerImpl!");
    }

    @Override
    public synchronized long createSession(int sessionTimeout) {
        this.addSession(this.nextSessionId, sessionTimeout);
        return this.nextSessionId++;
    }

    @Override
    public synchronized void addSession(long id, int sessionTimeout) {
        this.sessionsWithTimeout.put(id, sessionTimeout);
        if (this.sessionsById.get(id) == null) {
            Session s = new Session(id, 0L);
            this.sessionsById.put(id, s);
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Adding session 0x" + Long.toHexString(id) + " " + sessionTimeout);
        } else {
            ZooTrace.logTraceMessage(LOG, 32L, "SessionTrackerImpl --- Existing session 0x" + Long.toHexString(id) + " " + sessionTimeout);
        }
        this.touchSession(id, sessionTimeout);
    }

    @Override
    public void checkSession(long sessionId) throws KeeperException.SessionExpiredException {
        if (this.sessionsById.get(sessionId) == null) {
            throw new KeeperException.SessionExpiredException();
        }
    }

    static class SessionSet {
        long expireTime;
        HashSet<Session> sessions = new HashSet();

        SessionSet() {
        }
    }

    public static class Session {
        long tickTime;
        long sessionId;

        Session(long sessionId, long expireTime) {
            this.sessionId = sessionId;
            this.tickTime = expireTime;
        }
    }
}

