/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(SyncRequestProcessor.class);
    private ZooKeeperServer zks;
    private LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private RequestProcessor nextProcessor;
    boolean timeToDie = false;
    private LinkedList<Request> toFlush = new LinkedList();
    private Random r = new Random(System.nanoTime());
    private int logCount = 0;
    public static int snapCount = ZooKeeperServer.getSnapCount();
    private Request requestOfDeath = Request.requestOfDeath;

    public SyncRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("SyncThread:" + zks.getClientPort());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        this.start();
    }

    private void startSnapshot() throws IOException {
        this.zks.takeSnapshot();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request si = null;
                if (this.toFlush.isEmpty()) {
                    si = this.queuedRequests.take();
                } else {
                    si = this.queuedRequests.poll();
                    if (si == null) {
                        this.flush(this.toFlush);
                        continue;
                    }
                }
                if (si != this.requestOfDeath) {
                    if (si == null) continue;
                    this.zks.getLogWriter().append(si);
                    ++this.logCount;
                    if (this.logCount > snapCount / 2 && this.r.nextInt(snapCount / 2) == 0) {
                        this.zks.getLogWriter().rollLog();
                        this.startSnapshot();
                        this.logCount = 0;
                    }
                    this.toFlush.add(si);
                    if (this.toFlush.size() <= 1000) continue;
                    this.flush(this.toFlush);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Severe error, exiting", (Throwable)e);
            System.exit(11);
        }
        ZooTrace.logTraceMessage(LOG, ZooTrace.getTextTraceLevel(), "SyncRequestProcessor exited!");
    }

    private void flush(LinkedList<Request> toFlush) throws IOException {
        if (toFlush.size() == 0) {
            return;
        }
        this.zks.getLogWriter().commit();
        while (toFlush.size() > 0) {
            Request i = toFlush.remove();
            this.nextProcessor.processRequest(i);
        }
    }

    @Override
    public void shutdown() {
        this.timeToDie = true;
        this.queuedRequests.add(this.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    @Override
    public void processRequest(Request request) {
        this.queuedRequests.add(request);
    }
}

