/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperServer
implements SessionTracker.SessionExpirer,
ServerStats.Provider {
    private static final Logger LOG = Logger.getLogger(ZooKeeperServer.class);
    private static final int DEFAULT_TICK_TIME = 3000;
    protected int tickTime = 3000;
    public static final int commitLogCount = 500;
    public int commitLogBuffer = 700;
    public LinkedList<Leader.Proposal> committedLog = new LinkedList();
    public long minCommittedLog;
    public long maxCommittedLog;
    private DataTreeBuilder treeBuilder;
    public DataTree dataTree;
    protected SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    protected ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;
    protected long hzxid = 0L;
    public static final Exception ok = new Exception("No prob");
    protected RequestProcessor firstProcessor;
    LinkedBlockingQueue<Long> sessionsToDie = new LinkedBlockingQueue();
    protected volatile boolean running;
    private final long superSecret = 3007405056L;
    int requestsInProcess;
    List<ChangeRecord> outstandingChanges = new ArrayList<ChangeRecord>();
    private NIOServerCnxn.Factory serverCnxnFactory;
    private int clientPort;

    void removeCnxn(ServerCnxn cnxn) {
        this.dataTree.removeCnxn(cnxn);
    }

    public ZooKeeperServer() {
        ServerStats.getInstance().setStatsProvider(this);
        this.treeBuilder = new BasicDataTreeBuilder();
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, DataTreeBuilder treeBuilder) throws IOException {
        this.txnLogFactory = txnLogFactory;
        this.tickTime = tickTime;
        this.treeBuilder = treeBuilder;
        ServerStats.getInstance().setStatsProvider(this);
        LOG.info((Object)"Created server");
    }

    public ZooKeeperServer(File snapDir, File logDir, int tickTime) throws IOException {
        this(new FileTxnSnapLog(snapDir, logDir), tickTime, new BasicDataTreeBuilder());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, DataTreeBuilder treeBuilder) throws IOException {
        this(txnLogFactory, 3000, treeBuilder);
    }

    public void loadData() throws IOException, InterruptedException {
        long zxid;
        FileTxnSnapLog.PlayBackListener listener = new FileTxnSnapLog.PlayBackListener(){

            public void onTxnLoaded(TxnHeader hdr, Record txn) {
                Request r = new Request(null, 0L, hdr.getCxid(), hdr.getType(), null, null);
                r.txn = txn;
                r.hdr = hdr;
                r.zxid = hdr.getZxid();
                ZooKeeperServer.this.addCommittedProposal(r);
            }
        };
        this.sessionsWithTimeouts = new ConcurrentHashMap();
        this.dataTree = this.treeBuilder.build();
        this.hzxid = zxid = this.txnLogFactory.restore(this.dataTree, this.sessionsWithTimeouts, listener);
        LinkedList<Long> deadSessions = new LinkedList<Long>();
        for (long session : this.dataTree.getSessions()) {
            if (this.sessionsWithTimeouts.get(session) != null) continue;
            deadSessions.add(session);
        }
        this.dataTree.initialized = true;
        for (long session : deadSessions) {
            this.killSession(session, this.dataTree.lastProcessedZxid);
        }
        this.takeSnapshot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommittedProposal(Request request) {
        LinkedList<Leader.Proposal> linkedList = this.committedLog;
        synchronized (linkedList) {
            if (this.committedLog.size() > 500) {
                this.committedLog.removeFirst();
                this.minCommittedLog = this.committedLog.getFirst().packet.getZxid();
            }
            if (this.committedLog.size() == 0) {
                this.minCommittedLog = request.zxid;
                this.maxCommittedLog = request.zxid;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive boa = BinaryOutputArchive.getArchive(baos);
            try {
                request.hdr.serialize(boa, "hdr");
                if (request.txn != null) {
                    request.txn.serialize(boa, "txn");
                }
                baos.close();
            }
            catch (IOException e) {
                LOG.error((Object)"FIXMSG", (Throwable)e);
            }
            QuorumPacket pp = new QuorumPacket(2, request.zxid, baos.toByteArray(), null);
            Leader.Proposal p = new Leader.Proposal();
            p.packet = pp;
            p.request = request;
            this.committedLog.add(p);
            this.maxCommittedLog = p.packet.getZxid();
        }
    }

    public void takeSnapshot() {
        try {
            this.txnLogFactory.save(this.dataTree, this.sessionsWithTimeouts);
        }
        catch (IOException e) {
            LOG.error((Object)"Severe error, exiting", (Throwable)e);
            System.exit(10);
        }
    }

    public void serializeSnapshot(OutputArchive oa) throws IOException, InterruptedException {
        SerializeUtils.serializeSnapshot(this.dataTree, oa, this.sessionsWithTimeouts);
    }

    public void deserializeSnapshot(InputArchive ia) throws IOException {
        this.sessionsWithTimeouts = new ConcurrentHashMap();
        this.dataTree = this.treeBuilder.build();
        SerializeUtils.deserializeSnapshot(this.dataTree, ia, this.sessionsWithTimeouts);
    }

    public long getZxid() {
        return this.hzxid;
    }

    synchronized long getNextZxid() {
        return ++this.hzxid;
    }

    long getTime() {
        return System.currentTimeMillis();
    }

    public void closeSession(long sessionId) throws InterruptedException {
        ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- Session to be closed: 0x" + Long.toHexString(sessionId));
        this.submitRequest(null, sessionId, -11, 0, null, null);
    }

    protected void killSession(long sessionId, long zxid) {
        this.dataTree.killSession(sessionId, zxid);
        ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(sessionId));
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    @Override
    public void expire(long sessionId) {
        try {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- Session to expire: 0x" + Long.toHexString(sessionId));
            this.closeSession(sessionId);
        }
        catch (Exception e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
        }
    }

    void touch(ServerCnxn cnxn) throws IOException {
        int to;
        if (cnxn == null) {
            return;
        }
        long id = cnxn.getSessionId();
        if (!this.sessionTracker.touchSession(id, to = cnxn.getSessionTimeout())) {
            throw new IOException("Missing session 0x" + Long.toHexString(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws IOException, InterruptedException {
        if (this.dataTree == null) {
            this.loadData();
        }
        this.createSessionTracker();
        this.setupRequestProcessors();
        ZooKeeperServer zooKeeperServer = this;
        synchronized (zooKeeperServer) {
            this.running = true;
            this.notifyAll();
        }
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this, finalProcessor);
        this.firstProcessor = new PrepRequestProcessor(this, syncProcessor);
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.sessionsWithTimeouts, this.tickTime, 1L);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        this.running = false;
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.dataTree != null) {
            this.dataTree.clear();
        }
    }

    public synchronized void incInProcess() {
        ++this.requestsInProcess;
    }

    public synchronized void decInProcess() {
        --this.requestsInProcess;
    }

    public int getInProcess() {
        return this.requestsInProcess;
    }

    byte[] generatePasswd(long id) {
        Random r = new Random(id ^ 0xB3415C00L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        return p;
    }

    protected boolean checkPasswd(long sessionId, byte[] passwd) {
        return sessionId != 0L && Arrays.equals(passwd, this.generatePasswd(sessionId));
    }

    long createSession(ServerCnxn cnxn, byte[] passwd, int timeout) throws InterruptedException {
        long sessionId = this.sessionTracker.createSession(timeout);
        Random r = new Random(sessionId ^ 0xB3415C00L);
        r.nextBytes(passwd);
        ByteBuffer to = ByteBuffer.allocate(4);
        to.putInt(timeout);
        cnxn.setSessionId(sessionId);
        this.submitRequest(cnxn, sessionId, -10, 0, to, null);
        return sessionId;
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException, InterruptedException {
        boolean rc = this.sessionTracker.touchSession(sessionId, sessionTimeout);
        ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + rc);
        cnxn.finishSessionInit(rc);
    }

    public void reopenSession(ServerCnxn cnxn, long sessionId, byte[] passwd, int sessionTimeout) throws IOException, InterruptedException {
        if (!this.checkPasswd(sessionId, passwd)) {
            cnxn.finishSessionInit(false);
        } else {
            this.revalidateSession(cnxn, sessionId, sessionTimeout);
        }
    }

    public void closeSession(ServerCnxn cnxn, RequestHeader requestHeader) throws InterruptedException {
        this.closeSession(cnxn.getSessionId());
    }

    @Override
    public long getServerId() {
        return 0L;
    }

    public void submitRequest(ServerCnxn cnxn, long sessionId, int type, int xid, ByteBuffer bb, List<Id> authInfo) {
        Request si = new Request(cnxn, sessionId, xid, type, bb, authInfo);
        this.submitRequest(si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(Request si) {
        if (this.firstProcessor == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (!this.running) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"FIXMSG", (Throwable)e);
                }
                if (this.firstProcessor == null) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        try {
            this.touch(si.cnxn);
            boolean validpacket = Request.isValid(si.type);
            if (validpacket) {
                this.firstProcessor.processRequest(si);
                if (si.cnxn != null) {
                    this.incInProcess();
                }
            } else {
                LOG.warn((Object)("Dropping packet at server of type " + si.type));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
        }
    }

    public static void byteBuffer2Record(ByteBuffer bb, Record record) throws IOException {
        BinaryInputArchive ia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        record.deserialize(ia, "request");
    }

    public static int getSnapCount() {
        String sc = System.getProperty("zookeeper.snapCount");
        try {
            return Integer.parseInt(sc);
        }
        catch (Exception e) {
            return 10000;
        }
    }

    public int getGlobalOutstandingLimit() {
        int limit;
        String sc = System.getProperty("zookeeper.globalOutstandingLimit");
        try {
            limit = Integer.parseInt(sc);
        }
        catch (Exception e) {
            limit = 1000;
        }
        return limit;
    }

    public void setServerCnxnFactory(NIOServerCnxn.Factory factory) {
        this.serverCnxnFactory = factory;
    }

    public NIOServerCnxn.Factory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.dataTree.lastProcessedZxid;
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    public void truncateLog(long zxid) throws IOException {
        this.txnLogFactory.truncateLog(zxid);
    }

    public FileTxnSnapLog getLogWriter() {
        return this.txnLogFactory;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        this.tickTime = tickTime;
    }

    public DataTreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    public void setTreeBuilder(DataTreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public void setTxnLogFactory(FileTxnSnapLog txnLog) {
        this.txnLogFactory = txnLog;
    }

    public FileTxnSnapLog getTxnLogFactory() {
        return this.txnLogFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChangeRecord {
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long zxid, String path, StatPersisted stat, int childCount, List<ACL> acl) {
            this.zxid = zxid;
            this.path = path;
            this.stat = stat;
            this.childCount = childCount;
            this.acl = acl;
        }

        ChangeRecord duplicate(long zxid) {
            StatPersisted stat = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, stat);
            }
            return new ChangeRecord(zxid, this.path, stat, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
        }
    }

    public static class BasicDataTreeBuilder
    implements DataTreeBuilder {
        public DataTree build() {
            return new DataTree();
        }
    }

    public static interface DataTreeBuilder {
        public DataTree build();
    }

    public static interface Factory {
        public ZooKeeperServer createServer() throws IOException;

        public NIOServerCnxn.Factory createConnectionFactory() throws IOException;
    }
}

