/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;

public class ZooKeeperServerMain {
    private static final Logger LOG = Logger.getLogger(ZooKeeperServerMain.class);

    public static void main(String[] args) {
        ServerConfig.parse(args);
        ZooKeeperServerMain.runStandalone(new ZooKeeperServer.Factory(){

            public NIOServerCnxn.Factory createConnectionFactory() throws IOException {
                return new NIOServerCnxn.Factory(ServerConfig.getClientPort());
            }

            public ZooKeeperServer createServer() throws IOException {
                ZooKeeperServer zks = new ZooKeeperServer();
                zks.setClientPort(ServerConfig.getClientPort());
                FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(ServerConfig.getDataLogDir()), new File(ServerConfig.getDataDir()));
                zks.setTxnLogFactory(ftxn);
                return zks;
            }
        });
    }

    public static void runStandalone(ZooKeeperServer.Factory factory) {
        try {
            ServerStats.registerAsConcrete();
            ZooKeeperServer zk = factory.createServer();
            zk.startup();
            NIOServerCnxn.Factory t = factory.createConnectionFactory();
            t.setZooKeeperServer(zk);
            t.join();
            if (zk.isRunning()) {
                zk.shutdown();
            }
        }
        catch (Exception e) {
            LOG.fatal((Object)"Unexpected exception", (Throwable)e);
        }
        System.exit(0);
    }
}

