/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.auth.AuthenticationProvider;

public class HostAuthenticationProvider
implements AuthenticationProvider {
    public String getScheme() {
        return "host";
    }

    public int handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        String id = cnxn.getRemoteAddress().getAddress().getCanonicalHostName();
        cnxn.getAuthInfo().add(new Id(this.getScheme(), id));
        return 0;
    }

    public boolean matches(String id, String aclExpr) {
        String[] expParts;
        String[] idParts = id.split("\\.");
        int diff = idParts.length - (expParts = aclExpr.split("\\.")).length;
        if (diff < 0) {
            return false;
        }
        for (int i = 0; i < expParts.length; ++i) {
            if (!idParts[i + diff].equals(expParts[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isAuthenticated() {
        return false;
    }

    public boolean isValid(String id) {
        String[] parts;
        for (String part : parts = id.split("\\.")) {
            if (part.length() != 0) continue;
            return false;
        }
        return true;
    }
}

