/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;

public class FileTxnLog
implements TxnLog {
    long lastZxidSeen;
    volatile FileOutputStream logStream = null;
    volatile OutputArchive oa;
    File logDir;
    public static final int TXNLOG_MAGIC = ByteBuffer.wrap("ZKLG".getBytes()).getInt();
    public static final int VERSION = 2;
    private boolean forceSync = true;
    long dbId;
    private LinkedList<FileOutputStream> streamsToFlush = new LinkedList();
    static long preAllocSize = 0x4000000L;
    long currentSize;
    File logFileWrite = null;
    private static final Logger LOG = Logger.getLogger(FileTxnLog.class);

    public FileTxnLog(File logDir) {
        this.logDir = logDir;
        this.forceSync = !System.getProperty("zookeeper.forceSync", "yes").equals("no");
        String size = System.getProperty("zookeeper.preAllocSize");
        if (size != null) {
            try {
                preAllocSize = Long.parseLong(size) * 1024L;
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)(size + " is not a valid value for preAllocSize"));
            }
        }
    }

    public static void setPreallocSize(long size) {
        preAllocSize = size;
    }

    protected Checksum makeChecksumAlgorithm() {
        return new Adler32();
    }

    public void rollLog() {
        this.logStream = null;
        this.oa = null;
    }

    public synchronized void append(TxnHeader hdr, Record txn) throws IOException {
        if (hdr != null) {
            if (hdr.getZxid() <= this.lastZxidSeen) {
                LOG.warn((Object)("Current zxid " + hdr.getZxid() + " is <= " + this.lastZxidSeen + " for " + hdr.getType()));
            }
            if (this.logStream == null) {
                this.logFileWrite = new File(this.logDir, "log." + Long.toHexString(hdr.getZxid()));
                this.logStream = new FileOutputStream(this.logFileWrite);
                this.oa = BinaryOutputArchive.getArchive(this.logStream);
                FileHeader fhdr = new FileHeader(TXNLOG_MAGIC, 2, this.dbId);
                fhdr.serialize(this.oa, "fileheader");
                this.currentSize = this.logStream.getChannel().position();
                this.streamsToFlush.add(this.logStream);
            }
            this.padFile(this.logStream);
            byte[] buf = Util.marshallTxnEntry(hdr, txn);
            if (buf == null || buf.length == 0) {
                throw new IOException("Faulty serialization for header and txn");
            }
            Checksum crc = this.makeChecksumAlgorithm();
            crc.update(buf, 0, buf.length);
            this.oa.writeLong(crc.getValue(), "txnEntryCRC");
            Util.writeTxnBytes(this.oa, buf);
        }
    }

    private void padFile(FileOutputStream out) throws IOException {
        this.currentSize = Util.padLogFile(out, this.currentSize, preAllocSize);
    }

    public static File[] getLogFiles(File[] logDirList, long snapshotZxid) {
        List<File> files = Util.sortDataDir(logDirList, "log", true);
        long logZxid = 0L;
        for (File f : files) {
            long fzxid = Util.getZxidFromName(f.getName(), "log");
            if (fzxid > snapshotZxid || fzxid <= logZxid) continue;
            logZxid = fzxid;
        }
        ArrayList<File> v = new ArrayList<File>(5);
        for (File f : files) {
            long fzxid = Util.getZxidFromName(f.getName(), "log");
            if (fzxid < logZxid) continue;
            v.add(f);
        }
        return v.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastLoggedZxid() {
        long maxLog;
        File[] files = FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L);
        long zxid = maxLog = files.length > 0 ? Util.getZxidFromName(files[files.length - 1].getName(), "log") : -1L;
        FileOutputStream logStream = null;
        try {
            FileTxnLog txn = new FileTxnLog(this.logDir);
            TxnLog.TxnIterator itr = txn.read(maxLog);
            while (itr.next()) {
                TxnHeader hdr = itr.getHeader();
                zxid = hdr.getZxid();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Unexpected exception", (Throwable)e);
        }
        finally {
            if (logStream != null) {
                try {
                    logStream.close();
                }
                catch (IOException io) {}
            }
        }
        return zxid;
    }

    public synchronized void commit() throws IOException {
        for (FileOutputStream log : this.streamsToFlush) {
            log.flush();
            if (!this.forceSync) continue;
            log.getChannel().force(false);
        }
        while (this.streamsToFlush.size() > 1) {
            this.streamsToFlush.removeFirst().close();
        }
    }

    public TxnLog.TxnIterator read(long zxid) throws IOException {
        return new FileTxnIterator(this.logDir, zxid);
    }

    public boolean truncate(long zxid) throws IOException {
        FileTxnIterator itr = new FileTxnIterator(this.logDir, zxid);
        FileInputStream input = itr.inputStream;
        long pos = input.getChannel().position();
        RandomAccessFile raf = new RandomAccessFile(itr.logFile, "rw");
        raf.setLength(pos);
        raf.close();
        while (itr.goToNextLog()) {
            itr.logFile.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileHeader readHeader(File file) throws IOException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            BinaryInputArchive ia = BinaryInputArchive.getArchive(is);
            FileHeader hdr = new FileHeader();
            hdr.deserialize(ia, "fileheader");
            FileHeader fileHeader = hdr;
            return fileHeader;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public long getDbId() throws IOException {
        FileTxnIterator itr = new FileTxnIterator(this.logDir, 0L);
        FileHeader fh = FileTxnLog.readHeader(itr.logFile);
        itr.close();
        if (fh == null) {
            throw new IOException("Unsupported Format.");
        }
        return fh.getDbid();
    }

    public static class FileTxnIterator
    implements TxnLog.TxnIterator {
        File logDir;
        long zxid;
        TxnHeader hdr;
        Record record;
        File logFile;
        InputArchive ia;
        static final String CRC_ERROR = "CRC check failed";
        FileInputStream inputStream = null;
        private ArrayList<File> storedFiles;

        public FileTxnIterator(File logDir, long zxid) throws IOException {
            this.logDir = logDir;
            this.zxid = zxid;
            this.init();
        }

        void init() throws IOException {
            this.storedFiles = new ArrayList();
            List<File> files = Util.sortDataDir(FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L), "log", false);
            for (File f : files) {
                if (Util.getZxidFromName(f.getName(), "log") >= this.zxid) {
                    this.storedFiles.add(f);
                    continue;
                }
                if (Util.getZxidFromName(f.getName(), "log") >= this.zxid) continue;
                this.storedFiles.add(f);
                break;
            }
            this.goToNextLog();
            if (!this.next()) {
                return;
            }
            while (this.hdr.getZxid() < this.zxid) {
                this.next();
            }
        }

        private boolean goToNextLog() throws IOException {
            if (this.storedFiles.size() > 0) {
                this.logFile = this.storedFiles.remove(this.storedFiles.size() - 1);
                this.ia = this.createInputArchive(this.logFile);
                return true;
            }
            return false;
        }

        protected void inStreamCreated(InputArchive ia, FileInputStream is) throws IOException {
            FileHeader header = new FileHeader();
            header.deserialize(ia, "fileheader");
            if (header.getMagic() != TXNLOG_MAGIC) {
                throw new IOException("Invalid magic number " + header.getMagic() + " != " + TXNLOG_MAGIC);
            }
        }

        protected InputArchive createInputArchive(File logFile) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new FileInputStream(logFile);
                LOG.debug((Object)("Created new input stream " + logFile));
                this.ia = BinaryInputArchive.getArchive(new BufferedInputStream(this.inputStream));
                this.inStreamCreated(this.ia, this.inputStream);
                LOG.debug((Object)("created new input archive " + logFile));
            }
            return this.ia;
        }

        protected Checksum makeChecksumAlgorithm() {
            return new Adler32();
        }

        public boolean next() throws IOException {
            block6: {
                if (this.ia == null) {
                    return false;
                }
                try {
                    long crcValue = this.ia.readLong("crcvalue");
                    byte[] bytes = Util.readTxnBytes(this.ia);
                    if (bytes == null || bytes.length == 0) {
                        throw new EOFException("Failed to read");
                    }
                    Checksum crc = this.makeChecksumAlgorithm();
                    crc.update(bytes, 0, bytes.length);
                    if (crcValue != crc.getValue()) {
                        throw new IOException(CRC_ERROR);
                    }
                    if (bytes == null || bytes.length == 0) {
                        return false;
                    }
                    BinaryInputArchive iab = BinaryInputArchive.getArchive(new ByteArrayInputStream(bytes));
                    this.hdr = new TxnHeader();
                    this.record = SerializeUtils.deserializeTxn(iab, this.hdr);
                }
                catch (EOFException e) {
                    LOG.debug((Object)("EOF excepton " + e));
                    this.inputStream.close();
                    this.inputStream = null;
                    if (this.goToNextLog()) break block6;
                    return false;
                }
            }
            return true;
        }

        public TxnHeader getHeader() {
            return this.hdr;
        }

        public Record getTxn() {
            return this.record;
        }

        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

