/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import org.apache.zookeeper.server.quorum.QuorumPeer;

public class LeaderZooKeeperServer
extends ZooKeeperServer {
    private QuorumPeer self;
    CommitProcessor commitProcessor;

    LeaderZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder) throws IOException {
        super(logFactory, self.tickTime, treeBuilder);
        this.self = self;
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor(finalProcessor, this.getLeader().toBeApplied);
        this.commitProcessor = new CommitProcessor(toBeAppliedProcessor, Integer.toString(this.getClientPort()), false);
        ProposalRequestProcessor proposalProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        this.firstProcessor = new PrepRequestProcessor(this, proposalProcessor);
    }

    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.sessionsWithTimeouts, this.tickTime, this.self.getId());
    }

    public boolean touch(long sess, int to) {
        return this.sessionTracker.touchSession(sess, to);
    }

    public void setZxid(long zxid) {
        this.hzxid = zxid;
    }
}

