/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuorumPeerConfig
extends ServerConfig {
    private static final Logger LOG = Logger.getLogger(QuorumPeerConfig.class);
    private int tickTime;
    private int initLimit;
    private int syncLimit;
    private int electionAlg;
    private int electionPort;
    private HashMap<Long, QuorumPeer.QuorumServer> servers = null;
    private long serverId;

    private QuorumPeerConfig(int port, String dataDir, String dataLogDir) {
        super(port, dataDir, dataLogDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(String[] args) {
        if (instance != null) {
            return;
        }
        try {
            File zooCfgFile;
            if (args.length != 1) {
                System.err.println("USAGE: configFile");
                System.exit(2);
            }
            if (!(zooCfgFile = new File(args[0])).exists()) {
                LOG.error((Object)(zooCfgFile.toString() + " file is missing"));
                System.exit(2);
            }
            Properties cfg = new Properties();
            FileInputStream zooCfgStream = new FileInputStream(zooCfgFile);
            try {
                cfg.load(zooCfgStream);
            }
            finally {
                zooCfgStream.close();
            }
            HashMap<Long, QuorumPeer.QuorumServer> servers = new HashMap<Long, QuorumPeer.QuorumServer>();
            String dataDir = null;
            String dataLogDir = null;
            int clientPort = 0;
            int tickTime = 0;
            int initLimit = 0;
            int syncLimit = 0;
            int electionAlg = 3;
            int electionPort = 2182;
            for (Map.Entry<Object, Object> entry : cfg.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (key.equals("dataDir")) {
                    dataDir = value;
                    continue;
                }
                if (key.equals("dataLogDir")) {
                    dataLogDir = value;
                    continue;
                }
                if (key.equals("clientPort")) {
                    clientPort = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("tickTime")) {
                    tickTime = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("initLimit")) {
                    initLimit = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("syncLimit")) {
                    syncLimit = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("electionAlg")) {
                    electionAlg = Integer.parseInt(value);
                    continue;
                }
                if (key.startsWith("server.")) {
                    int dot = key.indexOf(46);
                    long sid = Long.parseLong(key.substring(dot + 1));
                    String[] parts = value.split(":");
                    if (parts.length != 2 && parts.length != 3) {
                        LOG.error((Object)(value + " does not have the form host:port or host:port:port"));
                    }
                    InetSocketAddress addr = new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
                    if (parts.length == 2) {
                        servers.put(sid, new QuorumPeer.QuorumServer(sid, addr));
                        continue;
                    }
                    if (parts.length != 3) continue;
                    InetSocketAddress electionAddr = new InetSocketAddress(parts[0], Integer.parseInt(parts[2]));
                    servers.put(sid, new QuorumPeer.QuorumServer(sid, addr, electionAddr));
                    continue;
                }
                System.setProperty("zookeeper." + key, value);
            }
            if (dataDir == null) {
                LOG.error((Object)"dataDir is not set");
                System.exit(2);
            }
            if (dataLogDir == null) {
                dataLogDir = dataDir;
            } else if (!new File(dataLogDir).isDirectory()) {
                LOG.error((Object)("dataLogDir " + dataLogDir + " is missing."));
                System.exit(2);
            }
            if (clientPort == 0) {
                LOG.error((Object)"clientPort is not set");
                System.exit(2);
            }
            if (tickTime == 0) {
                LOG.error((Object)"tickTime is not set");
                System.exit(2);
            }
            if (servers.size() > 1 && initLimit == 0) {
                LOG.error((Object)"initLimit is not set");
                System.exit(2);
            }
            if (servers.size() > 1 && syncLimit == 0) {
                LOG.error((Object)"syncLimit is not set");
                System.exit(2);
            }
            QuorumPeerConfig conf = new QuorumPeerConfig(clientPort, dataDir, dataLogDir);
            conf.tickTime = tickTime;
            conf.initLimit = initLimit;
            conf.syncLimit = syncLimit;
            conf.electionAlg = electionAlg;
            conf.servers = servers;
            if (servers.size() > 1) {
                String myIdString;
                File myIdFile;
                if (electionAlg != 0) {
                    for (QuorumPeer.QuorumServer s : servers.values()) {
                        if (s.electionAddr != null) continue;
                        LOG.error((Object)("Missing election port for server: " + s.id));
                    }
                }
                if (!(myIdFile = new File(dataDir, "myid")).exists()) {
                    LOG.error((Object)(myIdFile.toString() + " file is missing"));
                    System.exit(2);
                }
                BufferedReader br = new BufferedReader(new FileReader(myIdFile));
                try {
                    myIdString = br.readLine();
                }
                finally {
                    br.close();
                }
                try {
                    conf.serverId = Long.parseLong(myIdString);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)(myIdString + " is not a number"));
                    System.exit(2);
                }
            }
            instance = conf;
        }
        catch (Exception e) {
            LOG.error((Object)"FIXMSG", (Throwable)e);
            System.exit(2);
        }
    }

    @Override
    protected boolean isStandaloneServer() {
        return QuorumPeerConfig.getServers().size() <= 1;
    }

    public static int getTickTime() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).tickTime;
    }

    public static int getInitLimit() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).initLimit;
    }

    public static int getSyncLimit() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).syncLimit;
    }

    public static int getElectionAlg() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).electionAlg;
    }

    public static HashMap<Long, QuorumPeer.QuorumServer> getServers() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).servers;
    }

    public static int getQuorumSize() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).servers.size();
    }

    public static long getServerId() {
        assert (instance instanceof QuorumPeerConfig);
        return ((QuorumPeerConfig)QuorumPeerConfig.instance).serverId;
    }
}

