/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumStats;

public class QuorumPeerMain {
    private static final Logger LOG = Logger.getLogger(QuorumPeerMain.class);

    public static void main(String[] args) {
        if (args.length == 2) {
            ZooKeeperServerMain.main(args);
            return;
        }
        QuorumPeerConfig.parse(args);
        if (!QuorumPeerConfig.isStandalone()) {
            QuorumPeerMain.runPeer(new QuorumPeer.Factory(){

                public QuorumPeer create(NIOServerCnxn.Factory cnxnFactory) throws IOException {
                    QuorumPeer peer = new QuorumPeer();
                    peer.setClientPort(ServerConfig.getClientPort());
                    peer.setTxnFactory(new FileTxnSnapLog(new File(QuorumPeerConfig.getDataLogDir()), new File(QuorumPeerConfig.getDataDir())));
                    peer.setQuorumPeers(QuorumPeerConfig.getServers());
                    peer.setElectionType(QuorumPeerConfig.getElectionAlg());
                    peer.setMyid(QuorumPeerConfig.getServerId());
                    peer.setTickTime(QuorumPeerConfig.getTickTime());
                    peer.setInitLimit(QuorumPeerConfig.getInitLimit());
                    peer.setSyncLimit(QuorumPeerConfig.getSyncLimit());
                    peer.setCnxnFactory(cnxnFactory);
                    return peer;
                }

                public NIOServerCnxn.Factory createConnectionFactory() throws IOException {
                    return new NIOServerCnxn.Factory(ServerConfig.getClientPort());
                }
            });
        } else {
            ZooKeeperServerMain.main(args);
        }
    }

    public static void runPeer(QuorumPeer.Factory qpFactory) {
        try {
            QuorumStats.registerAsConcrete();
            QuorumPeer self = qpFactory.create(qpFactory.createConnectionFactory());
            self.start();
            self.join();
        }
        catch (Exception e) {
            LOG.fatal((Object)"Unexpected exception", (Throwable)e);
        }
        System.exit(2);
    }
}

