/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.HashSet;
import java.util.Map;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.DataTreeMXBean;

public class DataTreeBean
implements DataTreeMXBean,
ZKMBeanInfo {
    DataTree dataTree;

    public DataTreeBean(DataTree dataTree) {
        this.dataTree = dataTree;
    }

    @Override
    public int getNodeCount() {
        return this.dataTree.getNodeCount();
    }

    @Override
    public long approximateDataSize() {
        return this.dataTree.approximateDataSize();
    }

    @Override
    public int countEphemerals() {
        Map<Long, HashSet<String>> map = this.dataTree.getEphemeralsMap();
        int result = 0;
        for (HashSet<String> set : map.values()) {
            result += set.size();
        }
        return result;
    }

    @Override
    public int getWatchCount() {
        return this.dataTree.getWatchCount();
    }

    @Override
    public String getName() {
        return "InMemoryDataTree";
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getLastZxid() {
        return "0x" + Long.toHexString(this.dataTree.lastProcessedZxid);
    }
}

