/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.proto.AuthPacket;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.ConnectionBean;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.ProviderRegistry;

public class NIOServerCnxn
implements Watcher,
ServerCnxn {
    private static final Logger LOG = Logger.getLogger(NIOServerCnxn.class);
    private ConnectionBean jmxConnectionBean;
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    Factory factory;
    ZooKeeperServer zk;
    private SocketChannel sock;
    private SelectionKey sk;
    boolean initialized;
    ByteBuffer lenBuffer;
    ByteBuffer incomingBuffer;
    LinkedBlockingQueue<ByteBuffer> outgoingBuffers;
    int sessionTimeout;
    ArrayList<Id> authInfo;
    LinkedList<Request> outstanding;
    int outstandingRequests;
    long sessionId;
    static long nextSessionId = 1L;
    boolean closed;
    private static final byte[] fourBytes = new byte[4];
    private CnxnStats stats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBuffer(ByteBuffer bb) {
        if ((this.sk.interestOps() & 4) == 0) {
            try {
                this.sock.write(bb);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bb.remaining() == 0) {
            return;
        }
        Factory factory = this.factory;
        synchronized (factory) {
            this.sk.selector().wakeup();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Add a buffer to outgoingBuffers, sk " + this.sk + " is valid: " + this.sk.isValid()));
            }
            this.outgoingBuffers.add(bb);
            if (this.sk.isValid()) {
                this.sk.interestOps(this.sk.interestOps() | 4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIO(SelectionKey k) throws InterruptedException {
        block24: {
            try {
                if (this.sock == null) {
                    LOG.warn((Object)("trying to do i/o on a null socket for session:0x" + Long.toHexString(this.sessionId)));
                    return;
                }
                if (k.isReadable()) {
                    int rc = this.sock.read(this.incomingBuffer);
                    if (rc < 0) {
                        throw new IOException("Read error");
                    }
                    if (this.incomingBuffer.remaining() == 0) {
                        this.incomingBuffer.flip();
                        if (this.incomingBuffer == this.lenBuffer) {
                            this.readLength(k);
                        } else if (!this.initialized) {
                            ++this.stats.packetsReceived;
                            this.zk.serverStats().incrementPacketsReceived();
                            this.readConnectRequest();
                            this.lenBuffer.clear();
                            this.incomingBuffer = this.lenBuffer;
                        } else {
                            ++this.stats.packetsReceived;
                            this.zk.serverStats().incrementPacketsReceived();
                            this.readRequest();
                            this.lenBuffer.clear();
                            this.incomingBuffer = this.lenBuffer;
                        }
                    }
                }
                if (!k.isWritable()) break block24;
                if (this.outgoingBuffers.size() > 0) {
                    ByteBuffer directBuffer = this.factory.directBuffer;
                    directBuffer.clear();
                    for (ByteBuffer b : this.outgoingBuffers) {
                        if (directBuffer.remaining() < b.remaining()) {
                            b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                        }
                        int p = b.position();
                        directBuffer.put(b);
                        b.position(p);
                        if (directBuffer.remaining() != 0) continue;
                        break;
                    }
                    directBuffer.flip();
                    int sent = this.sock.write(directBuffer);
                    while (this.outgoingBuffers.size() > 0) {
                        ByteBuffer bb = this.outgoingBuffers.peek();
                        if (bb == closeConn) {
                            throw new IOException("closing");
                        }
                        int left = bb.remaining() - sent;
                        if (left > 0) {
                            bb.position(bb.position() + sent);
                            break;
                        }
                        ++this.stats.packetsSent;
                        sent -= bb.remaining();
                        if (this.zk != null) {
                            this.zk.serverStats().incrementPacketsSent();
                        }
                        this.outgoingBuffers.remove();
                    }
                }
                NIOServerCnxn directBuffer = this;
                synchronized (directBuffer) {
                    if (this.outgoingBuffers.size() == 0) {
                        if (!this.initialized && (this.sk.interestOps() & 1) == 0) {
                            throw new IOException("Responded to info probe");
                        }
                        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFB);
                    } else {
                        this.sk.interestOps(this.sk.interestOps() | 4);
                    }
                }
            }
            catch (CancelledKeyException e) {
                LOG.warn((Object)("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + " due to " + e));
                LOG.debug((Object)"CancelledKeyException stack trace", (Throwable)e);
                this.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + " due to " + e));
                LOG.debug((Object)"IOException stack trace", (Throwable)e);
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRequest() throws IOException {
        ByteBufferInputStream bais = new ByteBufferInputStream(this.incomingBuffer);
        BinaryInputArchive bia = BinaryInputArchive.getArchive(bais);
        RequestHeader h = new RequestHeader();
        h.deserialize(bia, "header");
        this.incomingBuffer = this.incomingBuffer.slice();
        if (h.getType() == 100) {
            AuthPacket authPacket = new AuthPacket();
            ZooKeeperServer.byteBuffer2Record(this.incomingBuffer, authPacket);
            String scheme = authPacket.getScheme();
            AuthenticationProvider ap = ProviderRegistry.getProvider(scheme);
            if (ap == null || ap.handleAuthentication(this, authPacket.getAuth()) != KeeperException.Code.OK) {
                if (ap == null) {
                    LOG.warn((Object)("No authentication provider for scheme: " + scheme + " has " + ProviderRegistry.listProviders()));
                } else {
                    LOG.warn((Object)("Authentication failed for scheme: " + scheme));
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.AUTHFAILED.intValue());
                this.sendResponse(rh, null, null);
                this.sendBuffer(closeConn);
                this.disableRecv();
            } else {
                LOG.debug((Object)("Authentication succeeded for scheme: " + scheme));
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.OK.intValue());
                this.sendResponse(rh, null, null);
            }
            return;
        }
        Request si = new Request(this, this.sessionId, h.getXid(), h.getType(), this.incomingBuffer, this.authInfo);
        si.setOwner(ServerCnxn.me);
        this.zk.submitRequest(si);
        if (h.getXid() >= 0) {
            NIOServerCnxn nIOServerCnxn = this;
            synchronized (nIOServerCnxn) {
                Factory factory = this.factory;
                synchronized (factory) {
                    ++this.outstandingRequests;
                    if (this.zk.getInProcess() > this.factory.outstandingLimit) {
                        LOG.debug((Object)("Throttling recv " + this.zk.getInProcess()));
                        this.disableRecv();
                    }
                }
            }
        }
    }

    public void disableRecv() {
        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFE);
    }

    public void enableRecv() {
        int interest;
        if (this.sk.isValid() && ((interest = this.sk.interestOps()) & 1) == 0) {
            this.sk.interestOps(interest | 1);
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException {
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(this.incomingBuffer));
        ConnectRequest connReq = new ConnectRequest();
        connReq.deserialize(bia, "connect");
        LOG.info((Object)("Connected to " + this.sock.socket().getRemoteSocketAddress() + " lastZxid " + connReq.getLastZxidSeen()));
        if (this.zk == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        if (connReq.getLastZxidSeen() > this.zk.dataTree.lastProcessedZxid) {
            String msg = "Client has seen zxid 0x" + Long.toHexString(connReq.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.zk.dataTree.lastProcessedZxid);
            LOG.warn((Object)msg);
            throw new IOException(msg);
        }
        this.sessionTimeout = connReq.getTimeOut();
        byte[] passwd = connReq.getPasswd();
        if (this.sessionTimeout < this.zk.tickTime * 2) {
            this.sessionTimeout = this.zk.tickTime * 2;
        }
        if (this.sessionTimeout > this.zk.tickTime * 20) {
            this.sessionTimeout = this.zk.tickTime * 20;
        }
        this.disableRecv();
        if (connReq.getSessionId() != 0L) {
            this.factory.closeSessionWithoutWakeup(connReq.getSessionId());
            this.setSessionId(connReq.getSessionId());
            this.zk.reopenSession(this, this.sessionId, passwd, this.sessionTimeout);
            LOG.info((Object)("Renewing session 0x" + Long.toHexString(this.sessionId)));
        } else {
            this.zk.createSession(this, passwd, this.sessionTimeout);
            LOG.info((Object)("Creating new session 0x" + Long.toHexString(this.sessionId)));
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized) {
            if (len == ruokCmd) {
                LOG.info((Object)("Processing ruok command from " + this.sock.socket().getRemoteSocketAddress()));
                this.sendBuffer(imok.duplicate());
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == getTraceMaskCmd) {
                LOG.info((Object)("Processing getracemask command from " + this.sock.socket().getRemoteSocketAddress()));
                long traceMask = ZooTrace.getTextTraceLevel();
                ByteBuffer resp = ByteBuffer.allocate(8);
                resp.putLong(traceMask);
                resp.flip();
                this.sendBuffer(resp);
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == setTraceMaskCmd) {
                LOG.info((Object)("Processing settracemask command from " + this.sock.socket().getRemoteSocketAddress()));
                this.incomingBuffer = ByteBuffer.allocate(8);
                int rc = this.sock.read(this.incomingBuffer);
                if (rc < 0) {
                    throw new IOException("Read error");
                }
                System.out.println("rc=" + rc);
                this.incomingBuffer.flip();
                long traceMask = this.incomingBuffer.getLong();
                ZooTrace.setTextTraceLevel(traceMask);
                ByteBuffer resp = ByteBuffer.allocate(8);
                resp.putLong(traceMask);
                resp.flip();
                this.sendBuffer(resp);
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == dumpCmd) {
                LOG.info((Object)("Processing dump command from " + this.sock.socket().getRemoteSocketAddress()));
                if (this.zk == null) {
                    this.sendBuffer(ByteBuffer.wrap("ZooKeeper not active \n".getBytes()));
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append("SessionTracker dump: \n");
                    sb.append(this.zk.sessionTracker.toString()).append("\n");
                    sb.append("ephemeral nodes dump:\n");
                    sb.append(this.zk.dataTree.dumpEphemerals()).append("\n");
                    this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                }
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == reqsCmd) {
                LOG.info((Object)("Processing reqs command from " + this.sock.socket().getRemoteSocketAddress()));
                StringBuffer sb = new StringBuffer();
                sb.append("Requests:\n");
                LinkedList<Request> traceMask = this.outstanding;
                synchronized (traceMask) {
                    for (Request r : this.outstanding) {
                        sb.append(r.toString());
                        sb.append('\n');
                    }
                }
                this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == statCmd) {
                LOG.info((Object)("Processing stat command from " + this.sock.socket().getRemoteSocketAddress()));
                StringBuffer sb = new StringBuffer();
                if (this.zk != null) {
                    sb.append("Zookeeper version: ").append(Version.getFullVersion()).append("\n");
                    sb.append("Clients:\n");
                    HashSet<NIOServerCnxn> traceMask = this.factory.cnxns;
                    synchronized (traceMask) {
                        for (NIOServerCnxn c : this.factory.cnxns) {
                            sb.append(c.getStats().toString());
                        }
                    }
                    sb.append("\n");
                    sb.append(this.zk.serverStats().toString());
                    sb.append("Node count: ").append(this.zk.dataTree.getNodeCount()).append("\n");
                } else {
                    sb.append("ZooKeeperServer not running\n");
                }
                this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == enviCmd) {
                LOG.info((Object)("Processing envi command from " + this.sock.socket().getRemoteSocketAddress()));
                StringBuffer sb = new StringBuffer();
                List<Environment.Entry> env = Environment.list();
                sb.append("Environment:\n");
                for (Environment.Entry e : env) {
                    sb.append(e.getKey()).append("=").append(e.getValue()).append("\n");
                }
                this.sendBuffer(ByteBuffer.wrap(sb.toString().getBytes()));
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
            if (len == srstCmd) {
                LOG.info((Object)("Processing srst command from " + this.sock.socket().getRemoteSocketAddress()));
                this.zk.serverStats().reset();
                this.sendBuffer(ByteBuffer.wrap("Stats reset.\n".getBytes()));
                this.sendBuffer(closeConn);
                k.interestOps(4);
                return;
            }
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (this.zk == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, Factory factory) throws IOException {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue();
        this.authInfo = new ArrayList();
        this.outstanding = new LinkedList();
        this.stats = new CnxnStats();
        this.zk = zk;
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(true, 2);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.authInfo.add(new Id("ip", addr.getHostAddress()));
        sk.interestOps(1);
    }

    public String toString() {
        return "NIOServerCnxn object with sock = " + this.sock + " and sk = " + this.sk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.jmxConnectionBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxConnectionBean);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxConnectionBean = null;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Cloneable e = this.factory.ipMap;
        synchronized (e) {
            Set<NIOServerCnxn> s = this.factory.ipMap.get(this.sock.socket().getInetAddress());
            s.remove(this);
        }
        e = this.factory.cnxns;
        synchronized (e) {
            this.factory.cnxns.remove(this);
        }
        if (this.zk != null) {
            this.zk.removeCnxn(this);
        }
        LOG.info((Object)("closing session:0x" + Long.toHexString(this.sessionId) + " NIOServerCnxn: " + this.sock));
        try {
            this.sock.socket().shutdownOutput();
        }
        catch (IOException e2) {
            LOG.debug((Object)"ignoring exception during output shutdown", (Throwable)e2);
        }
        try {
            this.sock.socket().shutdownInput();
        }
        catch (IOException e3) {
            LOG.debug((Object)"ignoring exception during input shutdown", (Throwable)e3);
        }
        try {
            this.sock.socket().close();
        }
        catch (IOException e4) {
            LOG.warn((Object)"ignoring exception during socket close", (Throwable)e4);
        }
        try {
            this.sock.close();
        }
        catch (IOException e5) {
            LOG.warn((Object)"ignoring exception during socketchannel close", (Throwable)e5);
        }
        this.sock = null;
        if (this.sk != null) {
            try {
                this.sk.cancel();
            }
            catch (Exception e2) {
                LOG.warn((Object)"ignoring exception during selectionkey cancel", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendResponse(ReplyHeader h, Record r, String tag) {
        if (this.closed) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
        try {
            baos.write(fourBytes);
            bos.writeRecord(h, "header");
            if (r != null) {
                bos.writeRecord(r, tag);
            }
            baos.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error serializing response");
        }
        byte[] b = baos.toByteArray();
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(b.length - 4).rewind();
        this.sendBuffer(bb);
        if (h.getXid() > 0) {
            Factory factory = this.factory;
            synchronized (factory) {
                --this.outstandingRequests;
                if (this.zk.getInProcess() < this.factory.outstandingLimit || this.outstandingRequests < 1) {
                    this.sk.selector().wakeup();
                    this.enableRecv();
                }
            }
        }
    }

    @Override
    public synchronized void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSessionInit(boolean valid) {
        try {
            this.jmxConnectionBean = new ConnectionBean(this, this.zk);
            MBeanRegistry.getInstance().register(this.jmxConnectionBean, this.zk.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to register with JMX", (Throwable)e);
            this.jmxConnectionBean = null;
        }
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? this.sessionTimeout : 0, valid ? this.sessionId : 0L, valid ? this.zk.generatePasswd(this.sessionId) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            this.sendBuffer(bb);
            LOG.info((Object)("Finished init of 0x" + Long.toHexString(this.sessionId) + " valid:" + valid));
            if (!valid) {
                this.sendBuffer(closeConn);
            }
            Factory factory = this.factory;
            synchronized (factory) {
                this.sk.selector().wakeup();
                this.enableRecv();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while establishing session, closing", (Throwable)e);
            this.close();
        }
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public ArrayList<Id> getAuthInfo() {
        return this.authInfo;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    @Override
    public ServerCnxn.Stats getStats() {
        return this.stats;
    }

    private class CnxnStats
    implements ServerCnxn.Stats {
        long packetsReceived;
        long packetsSent;

        private CnxnStats() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getOutstandingRequests() {
            NIOServerCnxn nIOServerCnxn = NIOServerCnxn.this;
            synchronized (nIOServerCnxn) {
                Factory factory = NIOServerCnxn.this.factory;
                synchronized (factory) {
                    return NIOServerCnxn.this.outstandingRequests;
                }
            }
        }

        @Override
        public long getPacketsReceived() {
            return this.packetsReceived;
        }

        @Override
        public long getPacketsSent() {
            return this.packetsSent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            SelectableChannel channel = NIOServerCnxn.this.sk.channel();
            if (channel instanceof SocketChannel) {
                sb.append(" ").append(((SocketChannel)channel).socket().getRemoteSocketAddress()).append("[").append(Integer.toHexString(NIOServerCnxn.this.sk.interestOps())).append("](queued=").append(this.getOutstandingRequests()).append(",recved=").append(this.getPacketsReceived()).append(",sent=").append(this.getPacketsSent()).append(")\n");
            }
            return sb.toString();
        }
    }

    public static class Factory
    extends Thread {
        ZooKeeperServer zks;
        ServerSocketChannel ss;
        Selector selector = Selector.open();
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(65536);
        HashSet<NIOServerCnxn> cnxns = new HashSet();
        HashMap<InetAddress, Set<NIOServerCnxn>> ipMap = new HashMap();
        int outstandingLimit = 1;
        int maxClientCnxns = 10;

        public Factory(int port) throws IOException {
            this(port, 0);
        }

        public Factory(int port, int maxcc) throws IOException {
            super("NIOServerCxn.Factory:" + port);
            this.setDaemon(true);
            this.maxClientCnxns = maxcc;
            this.ss = ServerSocketChannel.open();
            this.ss.socket().setReuseAddress(true);
            this.ss.socket().bind(new InetSocketAddress(port));
            this.ss.configureBlocking(false);
            this.ss.register(this.selector, 16);
        }

        @Override
        public void start() {
            if (this.getState() == Thread.State.NEW) {
                super.start();
            }
        }

        public void startup(ZooKeeperServer zks) throws IOException, InterruptedException {
            this.start();
            zks.startup();
            this.setZooKeeperServer(zks);
        }

        public void setZooKeeperServer(ZooKeeperServer zks) {
            this.zks = zks;
            if (zks != null) {
                this.outstandingLimit = zks.getGlobalOutstandingLimit();
                zks.setServerCnxnFactory(this);
            } else {
                this.outstandingLimit = 1;
            }
        }

        public ZooKeeperServer getZooKeeperServer() {
            return this.zks;
        }

        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
        }

        public int getLocalPort() {
            return this.ss.socket().getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCnxn(NIOServerCnxn cnxn) {
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                this.cnxns.add(cnxn);
                HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.ipMap;
                synchronized (hashMap) {
                    InetAddress addr = cnxn.sock.socket().getInetAddress();
                    Set<NIOServerCnxn> s = this.ipMap.get(addr);
                    if (s == null) {
                        s = new HashSet<NIOServerCnxn>();
                    }
                    s.add(cnxn);
                    this.ipMap.put(addr, s);
                }
            }
        }

        protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk) throws IOException {
            return new NIOServerCnxn(this.zks, sock, sk, this);
        }

        private int getClientCnxnCount(InetAddress cl) {
            Set<NIOServerCnxn> s = this.ipMap.get(cl);
            if (s == null) {
                return 0;
            }
            return s.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.ss.socket().isClosed()) {
                try {
                    Set<SelectionKey> selected;
                    this.selector.select(1000L);
                    Factory factory = this;
                    synchronized (factory) {
                        selected = this.selector.selectedKeys();
                    }
                    ArrayList<SelectionKey> selectedList = new ArrayList<SelectionKey>(selected);
                    Collections.shuffle(selectedList);
                    for (SelectionKey k : selectedList) {
                        if ((k.readyOps() & 0x10) != 0) {
                            SocketChannel sc = ((ServerSocketChannel)k.channel()).accept();
                            InetAddress ia = sc.socket().getInetAddress();
                            int cnxncount = this.getClientCnxnCount(ia);
                            if (this.maxClientCnxns > 0 && cnxncount >= this.maxClientCnxns) {
                                LOG.warn((Object)("Too many connections from " + ia + " - max is " + this.maxClientCnxns));
                                sc.close();
                                continue;
                            }
                            sc.configureBlocking(false);
                            SelectionKey sk = sc.register(this.selector, 1);
                            NIOServerCnxn cnxn = this.createConnection(sc, sk);
                            sk.attach(cnxn);
                            this.addCnxn(cnxn);
                            continue;
                        }
                        if ((k.readyOps() & 5) != 0) {
                            NIOServerCnxn c = (NIOServerCnxn)k.attachment();
                            c.doIO(k);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Unexpected ops in select " + k.readyOps()));
                    }
                    selected.clear();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Ignoring exception", (Throwable)e);
                }
            }
            this.clear();
            LOG.info((Object)"NIOServerCnxn factory exited run method");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void clear() {
            this.selector.wakeup();
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                Iterator<NIOServerCnxn> it = this.cnxns.iterator();
                while (it.hasNext()) {
                    NIOServerCnxn cnxn = it.next();
                    it.remove();
                    try {
                        cnxn.close();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Ignoring exception closing cnxn sessionid 0x" + Long.toHexString(cnxn.sessionId)), (Throwable)e);
                    }
                }
            }
        }

        public void shutdown() {
            try {
                this.ss.close();
                this.clear();
                this.interrupt();
                this.join();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Ignoring interrupted exception during shutdown", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn((Object)"Ignoring unexpected exception during shutdown", (Throwable)e);
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Selector closing", (Throwable)e);
            }
            if (this.zks != null) {
                this.zks.shutdown();
            }
        }

        synchronized void closeSession(long sessionId) {
            this.selector.wakeup();
            this.closeSessionWithoutWakeup(sessionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSessionWithoutWakeup(long sessionId) {
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                Iterator<NIOServerCnxn> it = this.cnxns.iterator();
                while (it.hasNext()) {
                    NIOServerCnxn cnxn = it.next();
                    if (cnxn.sessionId != sessionId) continue;
                    it.remove();
                    try {
                        cnxn.close();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"exception during session close", (Throwable)e);
                    }
                    break;
                }
            }
        }
    }
}

