/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.Flushable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;

public class SyncRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(SyncRequestProcessor.class);
    private ZooKeeperServer zks;
    private LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    private RequestProcessor nextProcessor;
    Thread snapInProcess = null;
    private LinkedList<Request> toFlush = new LinkedList();
    private Random r = new Random(System.nanoTime());
    private int logCount = 0;
    private static int snapCount = ZooKeeperServer.getSnapCount();
    private Request requestOfDeath = Request.requestOfDeath;

    public SyncRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("SyncThread:" + zks.getServerId());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    public static void setSnapCount(int count) {
        snapCount = count;
    }

    public static int getSnapCount() {
        return snapCount;
    }

    @Override
    public void run() {
        try {
            int randRoll = this.r.nextInt(snapCount / 2);
            while (true) {
                Request si = null;
                if (this.toFlush.isEmpty()) {
                    si = this.queuedRequests.take();
                } else {
                    si = this.queuedRequests.poll();
                    if (si == null) {
                        this.flush(this.toFlush);
                        continue;
                    }
                }
                if (si != this.requestOfDeath) {
                    if (si == null) continue;
                    this.zks.getLogWriter().append(si);
                    ++this.logCount;
                    if (this.logCount > snapCount / 2 + randRoll) {
                        randRoll = this.r.nextInt(snapCount / 2);
                        this.zks.getLogWriter().rollLog();
                        if (this.snapInProcess != null && this.snapInProcess.isAlive()) {
                            LOG.warn((Object)"Too busy to snap, skipping");
                        } else {
                            this.snapInProcess = new Thread("Snapshot Thread"){

                                @Override
                                public void run() {
                                    try {
                                        SyncRequestProcessor.this.zks.takeSnapshot();
                                    }
                                    catch (Exception e) {
                                        LOG.warn((Object)"Unexpected exception", (Throwable)e);
                                    }
                                }
                            };
                            this.snapInProcess.start();
                        }
                        this.logCount = 0;
                    }
                    this.toFlush.add(si);
                    if (this.toFlush.size() <= 1000) continue;
                    this.flush(this.toFlush);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Severe unrecoverable error, exiting", t);
            System.exit(11);
        }
        LOG.info((Object)"SyncRequestProcessor exited!");
    }

    private void flush(LinkedList<Request> toFlush) throws IOException {
        if (toFlush.size() == 0) {
            return;
        }
        this.zks.getLogWriter().commit();
        while (toFlush.size() > 0) {
            Request i = toFlush.remove();
            this.nextProcessor.processRequest(i);
        }
        if (this.nextProcessor instanceof Flushable) {
            ((Flushable)((Object)this.nextProcessor)).flush();
        }
    }

    @Override
    public void shutdown() {
        this.queuedRequests.add(this.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    @Override
    public void processRequest(Request request) {
        this.queuedRequests.add(request);
    }
}

