/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import org.apache.log4j.Logger;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPeer;

class AckRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(AckRequestProcessor.class);
    Leader leader;

    AckRequestProcessor(Leader leader) {
        this.leader = leader;
    }

    @Override
    public void processRequest(Request request) {
        QuorumPeer self = this.leader.self;
        if (self != null) {
            this.leader.processAck(self.getId(), request.zxid, null);
        } else {
            LOG.error((Object)"Null QuorumPeer");
        }
    }

    @Override
    public void shutdown() {
    }
}

