/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;

public class QuorumPeerConfig {
    private static final Logger LOG = Logger.getLogger(QuorumPeerConfig.class);
    protected int clientPort;
    protected String dataDir;
    protected String dataLogDir;
    protected int tickTime = 3000;
    protected int initLimit;
    protected int syncLimit;
    protected int electionAlg = 3;
    protected int electionPort = 2182;
    protected int maxClientCnxns = 10;
    protected final HashMap<Long, QuorumPeer.QuorumServer> servers = new HashMap();
    protected long serverId;
    protected HashMap<Long, Long> serverWeight = new HashMap();
    protected HashMap<Long, Long> serverGroup = new HashMap();
    protected int numGroups = 0;
    protected QuorumVerifier quorumVerifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String path) throws ConfigException {
        File configFile = new File(path);
        LOG.info((Object)("Reading configuration from: " + configFile));
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg = new Properties();
            FileInputStream in = new FileInputStream(configFile);
            try {
                cfg.load(in);
            }
            finally {
                in.close();
            }
            this.parseProperties(cfg);
        }
        catch (IOException e) {
            throw new ConfigException("Error processing " + path, e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Error processing " + path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseProperties(Properties zkProp) throws IOException, ConfigException {
        for (Map.Entry<Object, Object> entry : zkProp.entrySet()) {
            String[] parts;
            long sid;
            int dot;
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (key.equals("dataDir")) {
                this.dataDir = value;
                continue;
            }
            if (key.equals("dataLogDir")) {
                this.dataLogDir = value;
                continue;
            }
            if (key.equals("clientPort")) {
                this.clientPort = Integer.parseInt(value);
                continue;
            }
            if (key.equals("tickTime")) {
                this.tickTime = Integer.parseInt(value);
                continue;
            }
            if (key.equals("initLimit")) {
                this.initLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("syncLimit")) {
                this.syncLimit = Integer.parseInt(value);
                continue;
            }
            if (key.equals("electionAlg")) {
                this.electionAlg = Integer.parseInt(value);
                continue;
            }
            if (key.equals("maxClientCnxns")) {
                this.maxClientCnxns = Integer.parseInt(value);
                continue;
            }
            if (key.startsWith("server.")) {
                dot = key.indexOf(46);
                sid = Long.parseLong(key.substring(dot + 1));
                parts = value.split(":");
                if (parts.length != 2 && parts.length != 3) {
                    LOG.error((Object)(value + " does not have the form host:port or host:port:port"));
                }
                InetSocketAddress addr = new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
                if (parts.length == 2) {
                    this.servers.put(sid, new QuorumPeer.QuorumServer(sid, addr));
                    continue;
                }
                if (parts.length != 3) continue;
                InetSocketAddress electionAddr = new InetSocketAddress(parts[0], Integer.parseInt(parts[2]));
                this.servers.put(sid, new QuorumPeer.QuorumServer(sid, addr, electionAddr));
                continue;
            }
            if (key.startsWith("group")) {
                dot = key.indexOf(46);
                long gid = Long.parseLong(key.substring(dot + 1));
                ++this.numGroups;
                for (String s : parts = value.split(":")) {
                    long sid2 = Long.parseLong(s);
                    if (this.serverGroup.containsKey(sid2)) {
                        throw new ConfigException("Server " + sid2 + "is in multiple groups");
                    }
                    this.serverGroup.put(sid2, gid);
                }
                continue;
            }
            if (key.startsWith("weight")) {
                dot = key.indexOf(46);
                sid = Long.parseLong(key.substring(dot + 1));
                this.serverWeight.put(sid, Long.parseLong(value));
                continue;
            }
            System.setProperty("zookeeper." + key, value);
        }
        if (this.dataDir == null) {
            throw new IllegalArgumentException("dataDir is not set");
        }
        if (this.dataLogDir == null) {
            this.dataLogDir = this.dataDir;
        } else if (!new File(this.dataLogDir).isDirectory()) {
            throw new IllegalArgumentException("dataLogDir " + this.dataLogDir + " is missing.");
        }
        if (this.clientPort == 0) {
            throw new IllegalArgumentException("clientPort is not set");
        }
        if (this.tickTime == 0) {
            throw new IllegalArgumentException("tickTime is not set");
        }
        if (this.servers.size() > 1) {
            String myIdString;
            if (this.initLimit == 0) {
                throw new IllegalArgumentException("initLimit is not set");
            }
            if (this.syncLimit == 0) {
                throw new IllegalArgumentException("syncLimit is not set");
            }
            if (this.electionAlg != 0) {
                for (QuorumPeer.QuorumServer s : this.servers.values()) {
                    if (s.electionAddr != null) continue;
                    throw new IllegalArgumentException("Missing election port for server: " + s.id);
                }
            }
            if (this.serverGroup.size() > 0) {
                if (this.servers.size() != this.serverGroup.size()) {
                    throw new ConfigException("Every server must be in exactly one group");
                }
                for (QuorumPeer.QuorumServer s : this.servers.values()) {
                    if (this.serverWeight.containsKey(s.id)) continue;
                    this.serverWeight.put(s.id, 1L);
                }
                this.quorumVerifier = new QuorumHierarchical(this.numGroups, this.serverWeight, this.serverGroup);
            } else {
                LOG.info((Object)"Defaulting to majority quorums");
                this.quorumVerifier = new QuorumMaj(this.servers.size());
            }
            File myIdFile = new File(this.dataDir, "myid");
            if (!myIdFile.exists()) {
                throw new IllegalArgumentException(myIdFile.toString() + " file is missing");
            }
            BufferedReader br = new BufferedReader(new FileReader(myIdFile));
            try {
                myIdString = br.readLine();
            }
            finally {
                br.close();
            }
            try {
                this.serverId = Long.parseLong(myIdString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("serverid " + myIdString + " is not a number");
            }
        }
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public int getSyncLimit() {
        return this.syncLimit;
    }

    public int getElectionAlg() {
        return this.electionAlg;
    }

    public int getElectionPort() {
        return this.electionPort;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumVerifier;
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return Collections.unmodifiableMap(this.servers);
    }

    public long getServerId() {
        return this.serverId;
    }

    public boolean isDistributed() {
        return this.servers.size() > 1;
    }

    public static class ConfigException
    extends Exception {
        public ConfigException(String msg) {
            super(msg);
        }

        public ConfigException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

