/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.Flushable;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.QuorumPacket;

public class SendAckRequestProcessor
implements RequestProcessor,
Flushable {
    private static final Logger LOG = Logger.getLogger(SendAckRequestProcessor.class);
    Follower follower;

    SendAckRequestProcessor(Follower follower) {
        this.follower = follower;
    }

    @Override
    public void processRequest(Request si) {
        if (si.type != 9) {
            QuorumPacket qp = new QuorumPacket(3, si.hdr.getZxid(), null, null);
            try {
                this.follower.writePacket(qp, false);
            }
            catch (IOException e) {
                LOG.warn((Object)"Closing connection to leader, exception during packet send", (Throwable)e);
                try {
                    if (!this.follower.sock.isClosed()) {
                        this.follower.sock.close();
                    }
                }
                catch (IOException e1) {
                    LOG.debug((Object)"Ignoring error closing the connection", (Throwable)e1);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.follower.writePacket(null, true);
        }
        catch (IOException e) {
            LOG.warn((Object)"Closing connection to leader, exception during packet send", (Throwable)e);
            try {
                if (!this.follower.sock.isClosed()) {
                    this.follower.sock.close();
                }
            }
            catch (IOException e1) {
                LOG.debug((Object)"Ignoring error closing the connection", (Throwable)e1);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

