/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;

public class SerializeUtils {
    private static final Logger LOG = Logger.getLogger(SerializeUtils.class);

    public static Record deserializeTxn(InputArchive ia, TxnHeader hdr) throws IOException {
        hdr.deserialize(ia, "hdr");
        Record txn = null;
        switch (hdr.getType()) {
            case -10: {
                txn = new CreateSessionTxn();
                break;
            }
            case -11: {
                return null;
            }
            case 1: {
                txn = new CreateTxn();
                break;
            }
            case 2: {
                txn = new DeleteTxn();
                break;
            }
            case 5: {
                txn = new SetDataTxn();
                break;
            }
            case 7: {
                txn = new SetACLTxn();
                break;
            }
            case -1: {
                txn = new ErrorTxn();
            }
        }
        if (txn != null) {
            txn.deserialize(ia, "txn");
        }
        return txn;
    }

    public static void deserializeSnapshot(DataTree dt, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count = ia.readInt("count"); count > 0; --count) {
            long id = ia.readLong("id");
            int to = ia.readInt("timeout");
            sessions.put(id, to);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to);
        }
        dt.deserialize(ia, "tree");
    }

    public static void serializeSnapshot(DataTree dt, OutputArchive oa, Map<Long, Integer> sessions) throws IOException {
        HashMap<Long, Integer> sessSnap = new HashMap<Long, Integer>(sessions);
        oa.writeInt(sessSnap.size(), "count");
        for (Map.Entry<Long, Integer> entry : sessSnap.entrySet()) {
            oa.writeLong(entry.getKey(), "id");
            oa.writeInt(entry.getValue(), "timeout");
        }
        dt.serialize(oa, "tree");
    }
}

