/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.sts;

import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.delegation.TokenDelegationHandler;
import org.apache.cxf.sts.token.delegation.TokenDelegationParameters;
import org.apache.cxf.sts.token.delegation.TokenDelegationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FedizX509DelegationHandler
implements TokenDelegationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FedizX509DelegationHandler.class);

    public boolean canHandleToken(ReceivedToken delegateTarget) {
        Object token = delegateTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if ("http://www.w3.org/2000/09/xmldsig#".equals(namespace) && "X509Data".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    public TokenDelegationResponse isDelegationAllowed(TokenDelegationParameters tokenParameters) {
        TokenDelegationResponse response = new TokenDelegationResponse();
        ReceivedToken delegateTarget = tokenParameters.getToken();
        response.setToken(delegateTarget);
        if (!delegateTarget.isDOMElement()) {
            return response;
        }
        if (delegateTarget.getState() == ReceivedToken.STATE.VALID && delegateTarget.getPrincipal() != null) {
            response.setDelegationAllowed(true);
            LOG.debug("Delegation is allowed for: " + delegateTarget.getPrincipal());
        } else {
            LOG.debug("Delegation is not allowed, as the token is invalid or the principal is null");
        }
        return response;
    }
}

