/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.sts;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;

public class FileClaimsHandler
implements ClaimsHandler {
    private Map<String, Map<String, String>> userClaims;
    private List<String> supportedClaims;

    public void setUserClaims(Map<String, Map<String, String>> userClaims) {
        this.userClaims = userClaims;
    }

    public Map<String, Map<String, String>> getUserClaims() {
        return this.userClaims;
    }

    public void setSupportedClaims(List<String> supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    public List<String> getSupportedClaimTypes() {
        return Collections.unmodifiableList(this.supportedClaims);
    }

    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        if (this.getUserClaims() == null || parameters.getPrincipal() == null) {
            return new ProcessedClaimCollection();
        }
        if (claims == null || claims.isEmpty()) {
            return new ProcessedClaimCollection();
        }
        Map<String, String> claimMap = this.getUserClaims().get(parameters.getPrincipal().getName());
        if (claimMap == null || claimMap.isEmpty()) {
            return new ProcessedClaimCollection();
        }
        if (!claims.isEmpty()) {
            ProcessedClaimCollection claimCollection = new ProcessedClaimCollection();
            for (Claim requestClaim : claims) {
                String claimValue = claimMap.get(requestClaim.getClaimType().toString());
                if (claimValue == null) continue;
                ProcessedClaim claim = new ProcessedClaim();
                claim.setClaimType(requestClaim.getClaimType());
                claim.setIssuer("Test Issuer");
                claim.setOriginalIssuer("Original Issuer");
                claim.addValue((Object)claimValue);
                claimCollection.add((Object)claim);
            }
            return claimCollection;
        }
        return null;
    }
}

