/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.sts.realms;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;

public class RealmFileClaimsHandler
implements ClaimsHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(RealmFileClaimsHandler.class);
    private Map<String, Map<String, String>> userClaims;
    private List<String> supportedClaims;
    private String realm;

    public void setUserClaims(Map<String, Map<String, String>> userClaims) {
        this.userClaims = userClaims;
    }

    public Map<String, Map<String, String>> getUserClaims() {
        return this.userClaims;
    }

    public void setSupportedClaims(List<String> supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public List<String> getSupportedClaimTypes() {
        return Collections.unmodifiableList(this.supportedClaims);
    }

    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        if (parameters.getRealm() == null || !parameters.getRealm().equalsIgnoreCase(this.getRealm())) {
            LOG.fine("Realm '" + parameters.getRealm() + "' doesn't match with configured realm '" + this.getRealm() + "'");
            return new ProcessedClaimCollection();
        }
        if (this.getUserClaims() == null || parameters.getPrincipal() == null) {
            return new ProcessedClaimCollection();
        }
        if (claims == null || claims.isEmpty()) {
            LOG.fine("No claims requested");
            return new ProcessedClaimCollection();
        }
        Map<String, String> claimMap = this.getUserClaims().get(parameters.getPrincipal().getName());
        if (claimMap == null || claimMap.isEmpty()) {
            LOG.fine("Claims requested for principal '" + parameters.getPrincipal().getName() + "' but not found");
            return new ProcessedClaimCollection();
        }
        LOG.fine("Claims found for principal '" + parameters.getPrincipal().getName() + "'");
        if (!claims.isEmpty()) {
            ProcessedClaimCollection claimCollection = new ProcessedClaimCollection();
            for (Claim requestClaim : claims) {
                String claimValue = claimMap.get(requestClaim.getClaimType().toString());
                if (claimValue == null) continue;
                ProcessedClaim claim = new ProcessedClaim();
                claim.setClaimType(requestClaim.getClaimType());
                claim.setIssuer("Test Issuer");
                claim.setOriginalIssuer("Original Issuer");
                claim.addValue((Object)claimValue);
                claimCollection.add((Object)claim);
            }
            return claimCollection;
        }
        return null;
    }
}

