/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.sts.realms;

import java.security.cert.X509Certificate;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRealmCodec
implements SAMLRealmCodec {
    private static final Logger LOG = LoggerFactory.getLogger(SamlRealmCodec.class);
    private boolean uppercase = true;

    public String getRealmFromToken(SamlAssertionWrapper assertion) {
        SAMLKeyInfo ki = assertion.getSignatureKeyInfo();
        X509Certificate[] certs = ki.getCerts();
        String realm = this.parseCNValue(certs[0].getSubjectX500Principal().getName());
        LOG.info("Realm parsed in certificate: " + realm);
        return realm;
    }

    protected String parseCNValue(String name) {
        int len = name.indexOf(44) > 0 ? name.indexOf(44) : name.length();
        String realm = name.substring(name.indexOf("CN=") + 3, len);
        if (this.uppercase) {
            realm = realm.toUpperCase();
        }
        return realm;
    }

    public boolean isUppercase() {
        return this.uppercase;
    }

    public void setUppercase(boolean uppercase) {
        this.uppercase = uppercase;
    }
}

