/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.service.sts.realms;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriRealmParser
implements RealmParser {
    private static final Logger LOG = LoggerFactory.getLogger(UriRealmParser.class);
    private Map<String, Object> realmMap;

    public String parseRealm(Map<String, Object> messageContext) {
        String url = (String)messageContext.get("org.apache.cxf.request.url");
        StringTokenizer st = new StringTokenizer(url, "/");
        String realm = null;
        int count = st.countTokens();
        if (count <= 1) {
            return null;
        }
        --count;
        for (int i = 0; i < count; ++i) {
            realm = st.nextToken();
        }
        realm = realm.toUpperCase();
        if (this.realmMap == null || !this.realmMap.containsKey(realm)) {
            LOG.warn("Unknown realm: " + realm);
            throw new STSException("Unknown realm: " + realm);
        }
        LOG.debug("URI realm parsed: " + realm);
        return realm;
    }

    public Map<String, Object> getRealmMap() {
        return this.realmMap;
    }

    public void setRealmMap(Map<String, Object> realms) {
        this.realmMap = realms;
    }
}

