/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusImpl;
import org.apache.cxf.karaf.commands.CXFController;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="cxf", name="list-busses", description="Lists all CXF Busses.")
public class ListBussesCommand
extends OsgiCommandSupport {
    protected static final String HEADER_FORMAT = "%-40s %-20s";
    protected static final String OUTPUT_FORMAT = "[%-38s] [%-18s]";
    private CXFController cxfController;

    public void setController(CXFController controller) {
        this.cxfController = controller;
    }

    protected Object doExecute() throws Exception {
        List<Bus> busses = this.cxfController.getBusses();
        System.out.println(String.format(HEADER_FORMAT, "Name", "State"));
        for (Bus bus : busses) {
            String state = "";
            if (bus instanceof CXFBusImpl) {
                state = ((CXFBusImpl)bus).getState().toString();
            }
            System.out.println(String.format(OUTPUT_FORMAT, bus.getId(), state));
        }
        return null;
    }
}

