/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.karaf.commands.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.karaf.commands.CXFController;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CXFControllerImpl
implements CXFController {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFControllerImpl.class);
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public List<Bus> getBusses() {
        ArrayList<Bus> busses = new ArrayList<Bus>();
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(Bus.class.getName(), null);
            if (references != null) {
                for (ServiceReference reference : references) {
                    Bus bus;
                    if (reference == null || (bus = (Bus)this.bundleContext.getService(reference)) == null) continue;
                    busses.add(bus);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Cannot retrieve the list of CXF Busses.", e);
        }
        return busses;
    }

    @Override
    public Bus getBus(String name) {
        try {
            ServiceReference[] references = this.bundleContext.getServiceReferences(Bus.class.getName(), null);
            if (references != null) {
                for (ServiceReference reference : references) {
                    if (reference == null || !name.equals(reference.getProperty("cxf.bus.id"))) continue;
                    return (Bus)this.bundleContext.getService(reference);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Cannot retrieve the CXF Bus.", e);
            return null;
        }
        LOG.log(Level.INFO, "Cannot retrieve the CXF Bus " + name + ".");
        return null;
    }
}

