/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.crypto.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.xkms.crypto.CryptoProviderException;
import org.apache.ws.security.WSPasswordCallback;

final class CryptoProviderUtils {
    private CryptoProviderUtils() {
    }

    public static Properties loadKeystoreProperties(Message message, String propKey) {
        Object o = message.getContextualProperty(propKey);
        if (o == null) {
            throw new CryptoProviderException("Keystore properties path is not defined");
        }
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else {
            if (o instanceof String) {
                ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
                URL url = (URL)rm.resolveResource((String)o, URL.class);
                try {
                    if (url == null) {
                        url = ClassLoaderUtils.getResource((String)((String)o), CryptoProviderUtils.class);
                    }
                    if (url == null) {
                        try {
                            url = new URL((String)o);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (url == null) {
                        throw new CryptoProviderException("Keystore properties url is not resolved: " + o);
                    }
                    InputStream ins = url.openStream();
                    properties = new Properties();
                    properties.load(ins);
                    ins.close();
                }
                catch (IOException e) {
                    throw new CryptoProviderException("Cannot load keystore properties: " + e.getMessage(), (Throwable)e);
                }
            }
            if (o instanceof URL) {
                properties = new Properties();
                try {
                    InputStream ins = ((URL)o).openStream();
                    properties.load(ins);
                    ins.close();
                }
                catch (IOException e) {
                    throw new CryptoProviderException("Cannot load keystore properties: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (properties == null) {
            throw new CryptoProviderException("Cannot load keystore properties: " + o);
        }
        return properties;
    }

    public static String getKeystoreAlias(Properties keystoreProps) {
        String keystoreAlias = null;
        if (keystoreProps.containsKey("org.apache.ws.security.crypto.merlin.keystore.alias")) {
            keystoreAlias = keystoreProps.getProperty("org.apache.ws.security.crypto.merlin.keystore.alias");
        }
        if (keystoreAlias == null) {
            throw new CryptoProviderException("Alias is not found in keystore properties file: org.apache.ws.security.crypto.merlin.keystore.alias");
        }
        return keystoreAlias;
    }

    public static CallbackHandler getCallbackHandler(Message message) {
        Object o = message.getContextualProperty("ws-security.callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), CryptoProviderUtils.class).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }

    public static String getCallbackPwdFromMessage(Message message, String userName, int usage) {
        CallbackHandler handler = CryptoProviderUtils.getCallbackHandler(message);
        if (handler == null) {
            throw new CryptoProviderException("No callback handler and no password available");
        }
        return CryptoProviderUtils.getCallbackPwd(userName, usage, handler);
    }

    public static String getCallbackPwd(String userName, int usage, CallbackHandler handler) {
        if (handler == null) {
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, usage)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            throw new CryptoProviderException("Cannot get password from callback: " + e, (Throwable)e);
        }
        return cb[0].getPassword();
    }
}

