/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.crypto.impl;

import java.util.Properties;
import org.apache.cxf.message.Message;
import org.apache.cxf.xkms.crypto.CryptoProviderException;
import org.apache.cxf.xkms.crypto.CryptoProviderFactory;
import org.apache.cxf.xkms.crypto.impl.CryptoProviderUtils;
import org.apache.cxf.xkms.crypto.impl.XkmsCryptoProvider;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.w3._2002._03.xkms_wsdl.XKMSPortType;

public class XkmsCryptoProviderFactory
implements CryptoProviderFactory {
    private final XKMSPortType xkmsConsumer;

    public XkmsCryptoProviderFactory(XKMSPortType xkmsConsumer) {
        this.xkmsConsumer = xkmsConsumer;
    }

    public Crypto create(Message message) {
        Properties keystoreProps = CryptoProviderUtils.loadKeystoreProperties(message, "ws-security.signature.properties");
        try {
            Crypto defaultCrypto = CryptoFactory.getInstance((Properties)keystoreProps);
            return new XkmsCryptoProvider(this.xkmsConsumer, defaultCrypto);
        }
        catch (WSSecurityException e) {
            throw new CryptoProviderException("Cannot instantiate crypto factory: " + e.getMessage(), (Throwable)e);
        }
    }

    public Crypto create() {
        return new XkmsCryptoProvider(this.xkmsConsumer);
    }

    public Crypto create(Crypto fallbackCrypto) {
        return new XkmsCryptoProvider(this.xkmsConsumer, fallbackCrypto);
    }

    public Crypto create(XKMSPortType xkmsClient, Crypto fallbackCrypto) {
        return new XkmsCryptoProvider(xkmsClient, fallbackCrypto);
    }
}

