/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.crypto.provider;

import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.xkms.crypto.CryptoProviderException;
import org.apache.wss4j.common.ext.WSPasswordCallback;

final class CryptoProviderUtils {
    private CryptoProviderUtils() {
    }

    public static Properties loadKeystoreProperties(Message message, String propKey) {
        Object o = SecurityUtils.getSecurityPropertyValue((String)propKey, (Message)message);
        if (o == null) {
            throw new CryptoProviderException("Keystore properties path is not defined");
        }
        return SecurityUtils.loadProperties((Object)o);
    }

    public static String getKeystoreAlias(Properties keystoreProps) {
        String keystoreAlias = null;
        if (keystoreProps.containsKey("keystore.alias")) {
            keystoreAlias = keystoreProps.getProperty("keystore.alias");
        }
        if (keystoreAlias == null) {
            throw new CryptoProviderException("Alias is not found in keystore properties file: keystore.alias");
        }
        return keystoreAlias;
    }

    public static String getCallbackPwdFromMessage(Message message, String userName, int usage) {
        try {
            CallbackHandler handler = SecurityUtils.getCallbackHandler((Object)message);
            if (handler == null) {
                throw new CryptoProviderException("No callback handler and no password available");
            }
            return CryptoProviderUtils.getCallbackPwd(userName, usage, handler);
        }
        catch (Exception ex) {
            throw new CryptoProviderException("No callback handler and no password available", (Throwable)ex);
        }
    }

    public static String getCallbackPwd(String userName, int usage, CallbackHandler handler) {
        if (handler == null) {
            return null;
        }
        WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(userName, usage)};
        try {
            handler.handle((Callback[])cb);
        }
        catch (Exception e) {
            throw new CryptoProviderException("Cannot get password from callback: " + e, (Throwable)e);
        }
        return cb[0].getPassword();
    }
}

