/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.service;

import java.util.UUID;
import org.apache.cxf.xkms.model.xkms.RequestAbstractType;
import org.apache.cxf.xkms.model.xkms.ResultMajorEnum;
import org.apache.cxf.xkms.model.xkms.ResultType;

public final class XKMSResponseFactory {
    private XKMSResponseFactory() {
    }

    public static ResultType createResponse(RequestAbstractType request) {
        return XKMSResponseFactory.createResponse(request, new ResultType());
    }

    public static <T extends ResultType> T createResponse(RequestAbstractType request, T response) {
        response.setId(XKMSResponseFactory.generateUniqueID());
        XKMSResponseFactory.copyRequestId(request, response);
        XKMSResponseFactory.copyServiceName(request, response);
        XKMSResponseFactory.copyOpaqueClientData(request, response);
        response.setResultMajor(ResultMajorEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_SUCCESS.value());
        return response;
    }

    public static ResultType copyOpaqueClientData(RequestAbstractType request, ResultType response) {
        response.setOpaqueClientData(request.getOpaqueClientData());
        return response;
    }

    public static ResultType copyRequestId(RequestAbstractType request, ResultType response) {
        response.setRequestId(request.getId());
        return response;
    }

    public static ResultType copyServiceName(RequestAbstractType request, ResultType response) {
        response.setService(request.getService());
        return response;
    }

    public static String generateUniqueID() {
        return "I" + UUID.randomUUID().getMostSignificantBits();
    }
}

