/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.validator;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.handlers.Validator;
import org.apache.cxf.xkms.model.xkms.KeyBindingEnum;
import org.apache.cxf.xkms.model.xkms.KeyUsageEnum;
import org.apache.cxf.xkms.model.xkms.StatusType;
import org.apache.cxf.xkms.model.xkms.ValidateRequestType;
import org.apache.cxf.xkms.x509.repo.CertificateRepo;
import org.apache.cxf.xkms.x509.validator.ValidateRequestParser;

public class DirectTrustValidator
implements Validator {
    private static final Logger LOG = LogUtils.getL7dLogger(DirectTrustValidator.class);
    private final CertificateRepo certRepo;

    public DirectTrustValidator(CertificateRepo certRepo) {
        this.certRepo = certRepo;
    }

    public boolean isCertificateInRepo(X509Certificate certificate) {
        X509Certificate findCert = this.certRepo.findBySubjectDn(certificate.getSubjectDN().getName());
        return findCert != null;
    }

    public StatusType validate(ValidateRequestType request) {
        List keyUsages;
        StatusType status = new StatusType();
        if (request.getQueryKeyBinding() != null && (keyUsages = request.getQueryKeyBinding().getKeyUsage()).contains(KeyUsageEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_SIGNATURE)) {
            List<X509Certificate> certificates = ValidateRequestParser.parse(request);
            if (certificates == null || certificates.isEmpty()) {
                status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INDETERMINATE);
                status.getIndeterminateReason().add("http://www.cxf.apache.org/2002/03/xkms#RequestNotSupported");
                return status;
            }
            for (X509Certificate certificate : certificates) {
                if (this.isCertificateInRepo(certificate)) continue;
                LOG.warning("Certificate is not found in XKMS repo and is not directly trusted: " + certificate.getSubjectDN().getName());
                status.getInvalidReason().add("http://cxf.apache.org/xkms#DirectTrust");
                status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INVALID);
                return status;
            }
            status.getValidReason().add("http://cxf.apache.org/xkms#DirectTrust");
        }
        status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_VALID);
        return status;
    }
}

