/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.validator;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.handlers.Validator;
import org.apache.cxf.xkms.model.xkms.KeyBindingEnum;
import org.apache.cxf.xkms.model.xkms.ReasonEnum;
import org.apache.cxf.xkms.model.xkms.StatusType;
import org.apache.cxf.xkms.model.xkms.ValidateRequestType;
import org.apache.cxf.xkms.x509.validator.ValidateRequestParser;

public class DateValidator
implements Validator {
    private static final Logger LOG = LogUtils.getL7dLogger(DateValidator.class);

    public boolean isCertificateValid(X509Certificate certificate) {
        Instant now = Instant.now();
        try {
            certificate.checkValidity(Date.from(now));
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            return false;
        }
        return true;
    }

    public StatusType validate(ValidateRequestType request) {
        StatusType status = new StatusType();
        List<X509Certificate> certificates = ValidateRequestParser.parse(request);
        if (certificates == null || certificates.isEmpty()) {
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INDETERMINATE);
            status.getIndeterminateReason().add("http://www.cxf.apache.org/2002/03/xkms#RequestNotSupported");
        }
        if (this.isCertificateChainValid(certificates)) {
            status.getValidReason().add(ReasonEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_VALIDITY_INTERVAL.value());
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_VALID);
        } else {
            status.getInvalidReason().add(ReasonEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_VALIDITY_INTERVAL.value());
            status.setStatusValue(KeyBindingEnum.HTTP_WWW_W_3_ORG_2002_03_XKMS_INVALID);
        }
        return status;
    }

    public boolean isCertificateChainValid(List<X509Certificate> certificates) {
        if (certificates == null) {
            return false;
        }
        for (X509Certificate x509Certificate : certificates) {
            if (this.isCertificateValid(x509Certificate)) continue;
            LOG.info("Certificate is expired: " + x509Certificate.getSubjectX500Principal());
            return false;
        }
        return true;
    }
}

