/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xkms.x509.validator;

import jakarta.xml.bind.JAXBElement;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.xkms.exception.XKMSRequestException;
import org.apache.cxf.xkms.model.xkms.ValidateRequestType;
import org.apache.cxf.xkms.model.xmldsig.X509DataType;
import org.apache.cxf.xkms.x509.utils.X509Utils;

public final class ValidateRequestParser {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidateRequestParser.class);

    private ValidateRequestParser() {
    }

    public static List<X509Certificate> parse(ValidateRequestType request) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (request.getQueryKeyBinding() != null && request.getQueryKeyBinding().getKeyInfo() != null) {
            List keyInfoContent = request.getQueryKeyBinding().getKeyInfo().getContent();
            for (Object keyInfoObject : keyInfoContent) {
                JAXBElement dataInstance;
                if (!(keyInfoObject instanceof JAXBElement) || !X509Utils.X509_DATA.equals((dataInstance = (JAXBElement)keyInfoObject).getName())) continue;
                try {
                    X509Utils.parseX509Data((X509DataType)dataInstance.getValue(), certs);
                    LOG.fine("Extracted " + certs.size() + " certificates from ValidateRequest");
                }
                catch (CertificateException e) {
                    throw new XKMSRequestException("Corrupted X509 certificate in request: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return certs;
    }
}

