/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systests.cdi.base.AbstractCdiSingleAppTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCdiMultiAppTest
extends AbstractCdiSingleAppTest {
    @Test
    public void testAddOneBookWithValidation() {
        String id = UUID.randomUUID().toString();
        Response r = this.createWebClient("/rest/v2/bookstore/books").post((Object)new Form().param("id", id));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)r.getStatus());
        MatcherAssert.assertThat((Object)r.getHeaderString("X-Logged"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetBookStoreVersion() {
        Response r1 = this.createWebClient("/rest/v3/bookstore/versioned/version", "text/plain").get();
        r1.bufferEntity();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r1.getStatus());
        MatcherAssert.assertThat((Object)r1.readEntity(String.class), (Matcher)CoreMatchers.startsWith((String)"1.0."));
        Response r2 = this.createWebClient("/rest/v3/bookstore/versioned/version", "text/plain").get();
        r2.bufferEntity();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r2.getStatus());
        MatcherAssert.assertThat((Object)r2.readEntity(String.class), (Matcher)CoreMatchers.startsWith((String)"1.0."));
        MatcherAssert.assertThat((Object)r2.readEntity(String.class), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)r1.readEntity(String.class))));
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringRequestScopedBookstore() {
        Response r = this.createWebClient("/rest/v2/bookstore/request/books").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        MatcherAssert.assertThat((Object)r.getHeaderString("X-Logged"), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringCustomScopedBookstore() {
        Response r = this.createWebClient("/rest/v2/bookstore/custom/books").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        MatcherAssert.assertThat((Object)r.getHeaderString("X-Logged"), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringContractBookstore() {
        Response r = this.createWebClient("/rest/v2/bookstore/contract/books").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        MatcherAssert.assertThat((Object)r.getHeaderString("X-Logged"), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringMethodWithNameBinding() {
        Response r = this.createWebClient("/rest/v2/bookstore/books").get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        MatcherAssert.assertThat((Object)r.getHeaderString("X-Logged"), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Override
    protected WebClient createWebClient(String url) {
        return this.createWebClient(url, "application/json");
    }

    @Override
    protected WebClient createWebClient(String url, String mediaType) {
        List<JacksonJsonProvider> providers = Arrays.asList(new JacksonJsonProvider());
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort() + url), providers).accept(new String[]{mediaType});
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        return wc;
    }

    @Override
    protected String getBasePath() {
        return "/rest/v1/bookstore";
    }

    @Override
    protected abstract int getPort();
}

