/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base;

import java.net.URI;
import java.util.Collection;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systests.cdi.base.Book;
import org.apache.cxf.systests.cdi.base.BookStoreService;
import org.apache.cxf.systests.cdi.base.BookStoreVersion;
import org.apache.cxf.systests.cdi.base.Injections;
import org.apache.cxf.systests.cdi.base.bindings.Logged;

@Path(value="/bookstore/")
public class BookStore {
    private BookStoreService service;
    private BookStoreVersion bookStoreVersion;
    private UriInfo uriInfo;
    private Injections injections;

    public BookStore() {
    }

    @Inject
    public BookStore(BookStoreService service, BookStoreVersion bookStoreVersion, UriInfo uriInfo, Injections injections) {
        this.service = service;
        this.bookStoreVersion = bookStoreVersion;
        this.uriInfo = uriInfo;
        this.injections = injections;
    }

    @GET
    @Path(value="injections")
    public String injections() {
        return this.injections.state();
    }

    @Path(value="/version")
    public BookStoreVersion getVersion() {
        return this.bookStoreVersion;
    }

    @GET
    @Path(value="/books/{bookId}")
    @NotNull
    @Produces(value={"application/json"})
    public Book getBook(@PathParam(value="bookId") String id) {
        return this.service.get(id);
    }

    @GET
    @Path(value="/books")
    @NotNull
    @Valid
    @Produces(value={"application/json"})
    @Logged
    public Collection<Book> getBooks() {
        return this.service.all();
    }

    @POST
    @Path(value="/books")
    @Produces(value={"application/json"})
    public Response addBook(@NotNull @Size(min=1, max=50) @FormParam(value="id") @NotNull @Size(min=1, max=50) String id, @NotNull @FormParam(value="name") String name) {
        Book book = this.service.store(id, name);
        return Response.created((URI)this.uriInfo.getRequestUriBuilder().path(id).build(new Object[0])).entity((Object)book).build();
    }
}

