/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systests.cdi.base;

import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.systests.cdi.base.BookStoreService;
import org.apache.cxf.systests.cdi.base.bindings.Logged;
import org.apache.cxf.systests.cdi.base.scope.CustomScoped;

@Path(value="/bookstore/custom")
@CustomScoped
@Logged
public class CustomScopedBookStore {
    private BookStoreService service;
    private UriInfo uriInfo;

    public CustomScopedBookStore() {
    }

    @Inject
    public CustomScopedBookStore(BookStoreService service, UriInfo uriInfo) {
        this.service = service;
        this.uriInfo = uriInfo;
    }

    @GET
    @Path(value="/books")
    @NotNull
    @Valid
    @Produces(value={"application/json"})
    public Response getBooks() {
        return Response.ok().entity(this.service.all()).contentLocation(this.uriInfo.getAbsolutePath()).build();
    }
}

